"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccountLicensesSchema = exports.RoleSchema = exports.Role = exports.AccountCreationReasonSchema = exports.AccountCreationReason = exports.AccessLevelSchema = exports.AccessLevel = exports.PrivilegeEntity = void 0;
const zod_1 = require("zod");
const License_1 = require("../License/License");
/**
 *  Defines the target of the privilege
 *  @readonly
 *  @enum {string}
 */
var PrivilegeEntity;
(function (PrivilegeEntity) {
    /** Standard organization entity. */
    PrivilegeEntity["Organization"] = "organization";
    /** Parental organization, aka company. */
    PrivilegeEntity["Company"] = "company";
    /** Parental entity for companies. */
    PrivilegeEntity["CompanyNetwork"] = "companyNetwork";
})(PrivilegeEntity || (exports.PrivilegeEntity = PrivilegeEntity = {}));
/**
 *  Defines the user's level in the application.
 *  @readonly
 *  @enum {string}
 */
var AccessLevel;
(function (AccessLevel) {
    /** Just after the registration, should be disallowed to do anything until his accessLevel is changed by the admin. */
    AccessLevel["Preview"] = "preview";
    /** Basic level with limited rights. */
    AccessLevel["Open"] = "open";
    /** Common level for paid customers. */
    AccessLevel["Platform"] = "platform";
    /** AKA deleted, but the data remains. Archived user may not log in, but may be un-archived by admin. */
    AccessLevel["Archived"] = "archived";
    /** AKA Chuck Norris with unlimited rights for sOS stuff, but be aware that with great power comes the great responsibility. */
    AccessLevel["Admin"] = "admin";
})(AccessLevel || (exports.AccessLevel = AccessLevel = {}));
exports.AccessLevelSchema = zod_1.z.nativeEnum(AccessLevel);
var AccountCreationReason;
(function (AccountCreationReason) {
    AccountCreationReason["SignUp"] = "signup";
    AccountCreationReason["Invite"] = "invite";
})(AccountCreationReason || (exports.AccountCreationReason = AccountCreationReason = {}));
exports.AccountCreationReasonSchema = zod_1.z.nativeEnum(AccountCreationReason);
// Defines the user privilege role
// Role may be attached to account-organization or any other account-otherEntity relation (IPrivilegeEntity)
var Role;
(function (Role) {
    Role["Owner"] = "owner";
    Role["Master"] = "master";
    Role["User"] = "user";
    Role["Guest"] = "guest";
})(Role || (exports.Role = Role = {}));
exports.RoleSchema = zod_1.z.nativeEnum(Role);
exports.AccountLicensesSchema = zod_1.z.record(zod_1.z.string(), zod_1.z.array(License_1.LicenseSchema));
