import { z } from 'zod';
/**
 *  Defines the target of the privilege
 *  @readonly
 *  @enum {string}
 */
export declare enum PrivilegeEntity {
    /** Standard organization entity. */
    Organization = "organization",
    /** Parental organization, aka company. */
    Company = "company",
    /** Parental entity for companies. */
    CompanyNetwork = "companyNetwork"
}
/**
 *  Defines the user's level in the application.
 *  @readonly
 *  @enum {string}
 */
export declare enum AccessLevel {
    /** Just after the registration, should be disallowed to do anything until his accessLevel is changed by the admin. */
    Preview = "preview",
    /** Basic level with limited rights. */
    Open = "open",
    /** Common level for paid customers. */
    Platform = "platform",
    /** AKA deleted, but the data remains. Archived user may not log in, but may be un-archived by admin. */
    Archived = "archived",
    /** AKA Chuck Norris with unlimited rights for sOS stuff, but be aware that with great power comes the great responsibility. */
    Admin = "admin"
}
export declare const AccessLevelSchema: z.ZodNativeEnum<typeof AccessLevel>;
export declare enum AccountCreationReason {
    SignUp = "signup",
    Invite = "invite"
}
export declare const AccountCreationReasonSchema: z.ZodNativeEnum<typeof AccountCreationReason>;
export declare enum Role {
    Owner = "owner",
    Master = "master",
    User = "user",
    Guest = "guest"
}
export declare const RoleSchema: z.ZodNativeEnum<typeof Role>;
export declare const AccountLicensesSchema: z.ZodRecord<z.ZodString, z.ZodArray<z.ZodNativeEnum<typeof import("../License/License").License>, "many">>;
export type AccountLicenses = z.infer<typeof AccountLicensesSchema>;
