"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.uniqueHash = exports.now = exports.numericId = exports.uid = void 0;
const uid_1 = require("@signageos/common-types/dist/Entity/uid");
const checksum_1 = require("@signageos/lib/dist/Hash/checksum");
const generator_1 = require("@signageos/lib/dist/Hash/generator");
/**
 * Generates a unique UID in a standard format
 */
const uid = () => (0, uid_1.generateUid)();
exports.uid = uid;
/**
 * The old numeric id value generated in our system.
 */
const numericId = () => {
    return parseInt((0, checksum_1.checksumString)((0, exports.uid)()), 16) % Number.MAX_SAFE_INTEGER;
};
exports.numericId = numericId;
const now = () => new Date();
exports.now = now;
const uniqueHash = () => {
    return (0, generator_1.generateUniqueHash)();
};
exports.uniqueHash = uniqueHash;
//# sourceMappingURL=generators.js.map