"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCommandTypeOfSchema = getCommandTypeOfSchema;
exports.registerCommandSchema = registerCommandSchema;
exports.getCommandSchema = getCommandSchema;
exports.getAllCommandSchemas = getAllCommandSchemas;
const zod_1 = require("zod");
/** Based on input base command schema it returns the current type string literal */
function getCommandTypeOfSchema(schema) {
    if ('shape' in schema) {
        // is BasicActionCommandSchema
        return schema.shape.type.value;
    }
    else {
        // is DiscriminatedUnion with BasicActionCommandSchema
        const type = schema.options.values().next().value.shape.type.value;
        for (const option of schema.options.values()) {
            if (option.shape.type.value !== type) {
                throw new Error(`If the schema of command is z.DiscriminatedUnion, all options must have to have the same type: ${type}.`);
            }
        }
        return type;
    }
}
/** The schema used here only for get correct zod schema type including required literal property type. */
const createBaseCommandSchema = (type) => zod_1.z.strictObject({
    type: zod_1.z.literal(type),
});
const globalZodSchemaMap = new Map();
function registerCommandSchema(schema) {
    const commandType = getCommandTypeOfSchema(schema);
    if (globalZodSchemaMap.has(commandType)) {
        throw new Error(`Schema for command type "${commandType}" is already registered. It's designed to be registered only once.`);
    }
    globalZodSchemaMap.set(commandType, schema);
}
function getCommandSchema(type) {
    var _a;
    return (_a = globalZodSchemaMap.get(type)) !== null && _a !== void 0 ? _a : null;
}
function getAllCommandSchemas() {
    return Array.from(globalZodSchemaMap.values());
}
//# sourceMappingURL=commandSchemas.js.map