"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnassignWhiteLabelSettingsFromCompanyFactory = exports.UnassignWhiteLabelSettingsFromCompanySchema = exports.UnassignWhiteLabelSettingsFromCompany = exports.AssignWhiteLabelSettingsToCompanyFactory = exports.AssignWhiteLabelSettingsToCompanySchema = exports.AssignWhiteLabelSettingsToCompany = exports.UpdateWhiteLabelSettingsFactory = exports.UpdateWhiteLabelSettingsSchema = exports.UpdateWhiteLabelSettings = exports.CreateWhiteLabelSettingsWithUIThemeFactory = exports.CreateWhiteLabelSettingsWithUIThemeSchema = exports.CreateWhiteLabelSettingsWithUITheme = void 0;
const zod_1 = require("zod");
const ICommand_1 = require("../ICommand");
const generators_1 = require("../generators");
const commandFactory_1 = require("../commandFactory");
const uiThemeCommands_1 = require("../UITheme/uiThemeCommands");
const entityCommands_1 = require("../Entity/entityCommands");
const whiteLabelSettings_1 = require("./whiteLabelSettings");
const WhiteLabelSettingsUIDSchema_1 = require("./WhiteLabelSettingsUIDSchema");
/**
 * Create white label settings and its UI theme
 */
exports.CreateWhiteLabelSettingsWithUITheme = 'WhiteLabelSettings.CreateWhiteLabelSettingsWithUITheme';
exports.CreateWhiteLabelSettingsWithUIThemeSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.CreateWhiteLabelSettingsWithUITheme),
    whiteLabelSettings: whiteLabelSettings_1.WhiteLabelSettingsSchema,
    uiTheme: uiThemeCommands_1.UIThemeSchema,
}).strict();
exports.CreateWhiteLabelSettingsWithUIThemeFactory = (0, commandFactory_1.createCommandFactory)(exports.CreateWhiteLabelSettingsWithUIThemeSchema, {
    whiteLabelSettings: { uid: generators_1.uid },
    uiTheme: { uid: generators_1.uid },
});
exports.UpdateWhiteLabelSettings = 'WhiteLabelSettings.UpdateWhiteLabelSettings';
exports.UpdateWhiteLabelSettingsSchema = (0, entityCommands_1.createUpdateEntityCommandSchema)(exports.UpdateWhiteLabelSettings, whiteLabelSettings_1.WhiteLabelSettingsSchema);
exports.UpdateWhiteLabelSettingsFactory = (0, commandFactory_1.createCommandFactory)(exports.UpdateWhiteLabelSettingsSchema);
exports.AssignWhiteLabelSettingsToCompany = 'WhiteLabelSettings.AssignToCompany';
exports.AssignWhiteLabelSettingsToCompanySchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.AssignWhiteLabelSettingsToCompany),
    companyUid: zod_1.z.string(),
    whiteLabelSettingsUid: WhiteLabelSettingsUIDSchema_1.WhiteLabelSettingsUIDSchema,
}).strict();
exports.AssignWhiteLabelSettingsToCompanyFactory = (0, commandFactory_1.createCommandFactory)(exports.AssignWhiteLabelSettingsToCompanySchema);
exports.UnassignWhiteLabelSettingsFromCompany = 'WhiteLabelSettings.UnassignFromCompany';
exports.UnassignWhiteLabelSettingsFromCompanySchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.UnassignWhiteLabelSettingsFromCompany),
    companyUid: zod_1.z.string(),
    whiteLabelSettingsUid: WhiteLabelSettingsUIDSchema_1.WhiteLabelSettingsUIDSchema,
}).strict();
exports.UnassignWhiteLabelSettingsFromCompanyFactory = (0, commandFactory_1.createCommandFactory)(exports.UnassignWhiteLabelSettingsFromCompanySchema);
//# sourceMappingURL=whiteLabelSettingsCommands.js.map