"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WhiteLabelSettingsSchema = void 0;
const zod_1 = require("zod");
const entityCommands_1 = require("../Entity/entityCommands");
const schemas_1 = require("../schemas");
const EmailType_1 = require("@signageos/common-types/dist/Email/EmailType");
const FeatureFlag_1 = require("@signageos/common-types/dist/Feature/FeatureFlag");
const auth0Config = zod_1.z.strictObject({
    domain: zod_1.z.string(),
    clientId: zod_1.z.string(),
    organizationDomain: zod_1.z.string().optional(),
    organizationClientId: zod_1.z.string().optional(),
});
exports.WhiteLabelSettingsSchema = entityCommands_1.EntitySchema.extend({
    customDomain: schemas_1.DomainSchema.optional(),
    emailFooter: zod_1.z.string(),
    notificationEmailAddress: zod_1.z.string().email(),
    notificationEmailName: zod_1.z.string(),
    pageTitle: zod_1.z.string(),
    disabledFeatures: zod_1.z.array(FeatureFlag_1.FeatureFlagSchema).optional(),
    disabledEmailTypes: zod_1.z.array(EmailType_1.EmailTypeSchema).optional(),
    emailTemplateType: zod_1.z.string().optional(),
    privacyPolicyUrl: zod_1.z.string().optional(),
    auth0Config: auth0Config.optional(),
});
//# sourceMappingURL=whiteLabelSettings.js.map