import { z } from 'zod';
export declare const WhiteLabelSettingsSchema: z.ZodObject<{
    uid: z.ZodString;
    customDomain: z.ZodOptional<z.ZodEffects<z.ZodString, string, string>>;
    emailFooter: z.ZodString;
    notificationEmailAddress: z.ZodString;
    notificationEmailName: z.ZodString;
    pageTitle: z.ZodString;
    disabledFeatures: z.ZodOptional<z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Feature/FeatureFlag").FeatureFlag>, "many">>;
    disabledEmailTypes: z.ZodOptional<z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Email/EmailType").EmailType>, "many">>;
    emailTemplateType: z.ZodOptional<z.ZodString>;
    privacyPolicyUrl: z.ZodOptional<z.ZodString>;
    auth0Config: z.ZodOptional<z.ZodObject<{
        domain: z.ZodString;
        clientId: z.ZodString;
        organizationDomain: z.ZodOptional<z.ZodString>;
        organizationClientId: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        domain: string;
        clientId: string;
        organizationDomain?: string | undefined;
        organizationClientId?: string | undefined;
    }, {
        domain: string;
        clientId: string;
        organizationDomain?: string | undefined;
        organizationClientId?: string | undefined;
    }>>;
}, "strict", z.ZodTypeAny, {
    uid: string;
    emailFooter: string;
    notificationEmailAddress: string;
    notificationEmailName: string;
    pageTitle: string;
    customDomain?: string | undefined;
    disabledFeatures?: import("@signageos/common-types/dist/Feature/FeatureFlag").FeatureFlag[] | undefined;
    disabledEmailTypes?: import("@signageos/common-types/dist/Email/EmailType").EmailType[] | undefined;
    emailTemplateType?: string | undefined;
    privacyPolicyUrl?: string | undefined;
    auth0Config?: {
        domain: string;
        clientId: string;
        organizationDomain?: string | undefined;
        organizationClientId?: string | undefined;
    } | undefined;
}, {
    uid: string;
    emailFooter: string;
    notificationEmailAddress: string;
    notificationEmailName: string;
    pageTitle: string;
    customDomain?: string | undefined;
    disabledFeatures?: import("@signageos/common-types/dist/Feature/FeatureFlag").FeatureFlag[] | undefined;
    disabledEmailTypes?: import("@signageos/common-types/dist/Email/EmailType").EmailType[] | undefined;
    emailTemplateType?: string | undefined;
    privacyPolicyUrl?: string | undefined;
    auth0Config?: {
        domain: string;
        clientId: string;
        organizationDomain?: string | undefined;
        organizationClientId?: string | undefined;
    } | undefined;
}>;
