"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateUIThemeFactory = exports.UpdateUIThemeSchema = exports.UpdateUITheme = exports.UIThemeUIDSchema = exports.UIThemeSchema = void 0;
const zod_1 = require("zod");
const schemas_1 = require("../schemas");
const commandFactory_1 = require("../commandFactory");
const entityCommands_1 = require("../Entity/entityCommands");
const LayoutType_1 = require("@signageos/common-types/dist/Layout/LayoutType");
exports.UIThemeSchema = entityCommands_1.EntitySchema.extend({
    logo: zod_1.z.string().url(),
    topBarBackgroundColor1: schemas_1.HexColorSchema,
    topBarBackgroundColor2: schemas_1.HexColorSchema,
    tabsCardActiveColor: schemas_1.HexColorSchema,
    tabsCardActiveBackground: schemas_1.HexColorSchema,
    btnPrimaryColor: schemas_1.HexColorSchema,
    btnPrimaryBackground: schemas_1.HexColorSchema,
    menuItemColor: schemas_1.HexColorSchema,
    menuItemHoverBackground: schemas_1.HexColorSchema,
    menuItemActiveBackground: schemas_1.HexColorSchema,
    hideMenuButtonColor: schemas_1.HexColorSchema,
    textColor: schemas_1.HexColorSchema,
    cardTitleColor: schemas_1.HexColorSchema,
    favicon: zod_1.z.string().url().optional(),
    logoSmall: zod_1.z.string().url().optional(),
    layout: LayoutType_1.LayoutTypeSchema.optional(),
});
exports.UIThemeUIDSchema = exports.UIThemeSchema.shape.uid;
exports.UpdateUITheme = 'UITheme.UpdateUITheme';
exports.UpdateUIThemeSchema = (0, entityCommands_1.createUpdateEntityCommandSchema)(exports.UpdateUITheme, exports.UIThemeSchema);
exports.UpdateUIThemeFactory = (0, commandFactory_1.createCommandFactory)(exports.UpdateUIThemeSchema);
//# sourceMappingURL=uiThemeCommands.js.map