import { z } from 'zod';
export declare const SetThirdPartyCredentials = "ThirdPartyCredentials.Set";
/**
 * @description Set third party credentials for organization
 * @param organizationUid - is unique per type and if there are already credentials
 * for that organization with that type they will be overwritten
 */
export declare const SetThirdPartyCredentialsSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"ThirdPartyCredentials.Set">;
    organizationUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    uid: z.ZodString;
    thirdPartyType: z.ZodLiteral<"google">;
    clientEmail: z.ZodString;
    customerId: z.ZodString;
    privateKey: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "ThirdPartyCredentials.Set";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    thirdPartyType: "google";
    clientEmail: string;
    customerId: string;
    privateKey: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "ThirdPartyCredentials.Set";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    thirdPartyType: "google";
    clientEmail: string;
    customerId: string;
    privateKey: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type SetThirdPartyCredentials = z.infer<typeof SetThirdPartyCredentialsSchema>;
export declare const SetThirdPartyCredentialsFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    thirdPartyType: "google";
    clientEmail: string;
    customerId: string;
    privateKey: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "ThirdPartyCredentials.Set";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    thirdPartyType: "google";
    clientEmail: string;
    customerId: string;
    privateKey: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"ThirdPartyCredentials.Set">;
    organizationUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    uid: z.ZodString;
    thirdPartyType: z.ZodLiteral<"google">;
    clientEmail: z.ZodString;
    customerId: z.ZodString;
    privateKey: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "ThirdPartyCredentials.Set";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    thirdPartyType: "google";
    clientEmail: string;
    customerId: string;
    privateKey: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "ThirdPartyCredentials.Set";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    thirdPartyType: "google";
    clientEmail: string;
    customerId: string;
    privateKey: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
