"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MarkTermsAgreedFactory = exports.MarkTermsAgreedSchema = exports.MarkTermsAgreed = void 0;
const commandFactory_1 = require("../commandFactory");
const zod_1 = require("zod");
const ICommand_1 = require("../ICommand");
exports.MarkTermsAgreed = 'Terms.MarkAgreed';
exports.MarkTermsAgreedSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.MarkTermsAgreed),
    accountId: zod_1.z.number(),
    termsAndConditionsUid: zod_1.z.string().optional(),
    dateAgreedOn: zod_1.z.date(),
    termsVersion: zod_1.z.string(),
}).strict();
exports.MarkTermsAgreedFactory = (0, commandFactory_1.createCommandFactory)(exports.MarkTermsAgreedSchema);
//# sourceMappingURL=termsCommands.js.map