"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnarchivePolicyFactory = exports.UnarchivePolicySchema = exports.UnarchivePolicy = exports.ArchivePolicyFactory = exports.ArchivePolicySchema = exports.ArchivePolicy = exports.UpdatePolicyNameFactory = exports.UpdatePolicyNameSchema = exports.UpdatePolicyName = exports.UpdatePolicyFactory = exports.UpdatePolicySchema = exports.UpdatePolicy = exports.ClonePolicyFactory = exports.ClonePolicySchema = exports.ClonePolicy = exports.CreatePolicyFactory = exports.CreatePolicySchema = exports.CreatePolicy = void 0;
const commandFactory_1 = require("../commandFactory");
const zod_1 = require("zod");
const ICommand_1 = require("../ICommand");
const IPolicyItem_1 = require("@signageos/common-types/dist/Policy/IPolicyItem");
exports.CreatePolicy = 'Policy.CreatePolicy';
exports.CreatePolicySchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.CreatePolicy),
    name: zod_1.z.string(),
    organizationUid: zod_1.z.string(),
    items: zod_1.z.array(IPolicyItem_1.PolicyItemSchema).optional(),
});
exports.CreatePolicyFactory = (0, commandFactory_1.createCommandFactory)(exports.CreatePolicySchema);
exports.ClonePolicy = 'Policy.ClonePolicy';
exports.ClonePolicySchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.ClonePolicy),
    patternUid: zod_1.z.string(),
    name: zod_1.z.string(),
    organizationUid: zod_1.z.string(),
});
exports.ClonePolicyFactory = (0, commandFactory_1.createCommandFactory)(exports.ClonePolicySchema);
exports.UpdatePolicy = 'Policy.UpdatePolicy';
exports.UpdatePolicySchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.UpdatePolicy),
    uid: zod_1.z.string(),
    items: zod_1.z.array(IPolicyItem_1.PolicyItemSchema),
    /**
     * Human-readable note that describes the context and purpose of the update
     *
     * These notes then serve as a log of changes that anybody can review in retrospect.
     * Sort of like git log.
     */
    note: zod_1.z.string().optional(),
});
exports.UpdatePolicyFactory = (0, commandFactory_1.createCommandFactory)(exports.UpdatePolicySchema);
exports.UpdatePolicyName = 'Policy.UpdatePolicyName';
exports.UpdatePolicyNameSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.UpdatePolicyName),
    uid: zod_1.z.string(),
    name: zod_1.z.string(),
});
exports.UpdatePolicyNameFactory = (0, commandFactory_1.createCommandFactory)(exports.UpdatePolicyNameSchema);
exports.ArchivePolicy = 'Policy.ArchivePolicy';
exports.ArchivePolicySchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.ArchivePolicy),
    uid: zod_1.z.string(),
});
exports.ArchivePolicyFactory = (0, commandFactory_1.createCommandFactory)(exports.ArchivePolicySchema);
exports.UnarchivePolicy = 'Policy.UnarchivePolicy';
exports.UnarchivePolicySchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.UnarchivePolicy),
    uid: zod_1.z.string(),
});
exports.UnarchivePolicyFactory = (0, commandFactory_1.createCommandFactory)(exports.UnarchivePolicySchema);
//# sourceMappingURL=policyCommands.js.map