import { z } from 'zod';
export declare const CreatePolicy = "Policy.CreatePolicy";
export declare const CreatePolicySchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Policy.CreatePolicy">;
    name: z.ZodString;
    organizationUid: z.ZodString;
    items: z.ZodOptional<z.ZodArray<z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            volume: z.ZodNumber;
        }, "strict", z.ZodTypeAny, {
            volume: number;
        }, {
            volume: number;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<{
            brightness: z.ZodNumber;
            time: z.ZodString;
        }, "strict", z.ZodTypeAny, {
            time: string;
            brightness: number;
        }, {
            time: string;
            brightness: number;
        }>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<{
            type: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType>;
            weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum>, "many">;
            timeOn: z.ZodNullable<z.ZodString>;
            timeOff: z.ZodNullable<z.ZodString>;
            volume: z.ZodNumber;
        }, "strict", z.ZodTypeAny, {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }, {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<{
            type: z.ZodType<`TIMER_${number}`, z.ZodTypeDef, `TIMER_${number}`>;
            weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum>, "many">;
            timeOn: z.ZodNullable<z.ZodString>;
            timeOff: z.ZodNullable<z.ZodString>;
            keepAppletRunning: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }, {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            width: z.ZodNumber;
            height: z.ZodNumber;
            framerate: z.ZodOptional<z.ZodNumber>;
        }, "strict", z.ZodTypeAny, {
            height: number;
            width: number;
            framerate?: number | undefined;
        }, {
            height: number;
            width: number;
            framerate?: number | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            orientation: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/Resolution/Orientation").default>;
            videoOrientation: z.ZodOptional<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default>>;
        }, "strict", z.ZodTypeAny, {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        }, {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
        }, {
            enabled: boolean;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            version: z.ZodString;
        }, "strict", z.ZodTypeAny, {
            version: string;
        }, {
            version: string;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            version: z.ZodString;
        }, "strict", z.ZodTypeAny, {
            version: string;
        }, {
            version: string;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            appletEnabled: z.ZodBoolean;
            nativeEnabled: z.ZodBoolean;
        }, "strict", z.ZodTypeAny, {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        }, {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            timezone: z.ZodNullable<z.ZodString>;
            ntpServer: z.ZodNullable<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            timezone: string | null;
            ntpServer: string | null;
        }, {
            timezone: string | null;
            ntpServer: string | null;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<{
            uid: z.ZodString;
            powerType: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/Power/PowerActionType").default>;
            weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum>, "many">;
            time: z.ZodString;
        }, "strict", z.ZodTypeAny, {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }, {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            temperatureLimit: z.ZodNumber;
        }, "strict", z.ZodTypeAny, {
            temperatureLimit: number;
        }, {
            temperatureLimit: number;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
            healthcheckIntervalMs: z.ZodOptional<z.ZodNumber>;
            autoEnableTimeoutMs: z.ZodOptional<z.ZodNumber>;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        }, {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
            urlLauncherAddress: z.ZodOptional<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        }, {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
            uri: z.ZodNullable<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
            uri: string | null;
        }, {
            enabled: boolean;
            uri: string | null;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodNullable<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/socketDriver").SocketDriver>>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            toInstall: z.ZodArray<z.ZodObject<{
                packageName: z.ZodString;
                ownerOrganizationUid: z.ZodString;
                buildHash: z.ZodString;
                version: z.ZodString;
                build: z.ZodNullable<z.ZodString>;
                applicationType: z.ZodLiteral<"android">;
                specs: z.ZodObject<{
                    packageName: z.ZodString;
                    sdkVersion: z.ZodNumber;
                    supportedAbis: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodEnum<["x86", "x86_64", "armeabi-v7a", "arm64-v8a"]>, z.ZodString]>, "many">>;
                    multiArch: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
                    versionCode: z.ZodOptional<z.ZodNumber>;
                    targetSdkVersion: z.ZodOptional<z.ZodNumber>;
                }, "strip", z.ZodTypeAny, {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                }, {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                }>;
            }, "strict", z.ZodTypeAny, {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }, {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }>, "many">;
            toUninstall: z.ZodArray<z.ZodObject<{
                packageName: z.ZodString;
                applicationType: z.ZodLiteral<"android">;
                specs: z.ZodObject<{
                    packageName: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    packageName: string;
                }, {
                    packageName: string;
                }>;
            }, "strict", z.ZodTypeAny, {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }, {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }>, "many">;
        }, "strip", z.ZodTypeAny, {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        }, {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            telemetryIntervals: z.ZodObject<{
                screenshots: z.ZodOptional<z.ZodNumber>;
                temperature: z.ZodOptional<z.ZodNumber>;
                applicationVersion: z.ZodOptional<z.ZodNumber>;
                frontDisplayVersion: z.ZodOptional<z.ZodNumber>;
                brightness: z.ZodOptional<z.ZodNumber>;
                datetime: z.ZodOptional<z.ZodNumber>;
                debug: z.ZodOptional<z.ZodNumber>;
                firmwareVersion: z.ZodOptional<z.ZodNumber>;
                orientation: z.ZodOptional<z.ZodNumber>;
                powerActionsSchedule: z.ZodOptional<z.ZodNumber>;
                proprietaryTimers: z.ZodOptional<z.ZodNumber>;
                remoteControl: z.ZodOptional<z.ZodNumber>;
                resolution: z.ZodOptional<z.ZodNumber>;
                timers: z.ZodOptional<z.ZodNumber>;
                volume: z.ZodOptional<z.ZodNumber>;
                storage: z.ZodOptional<z.ZodNumber>;
                battery: z.ZodOptional<z.ZodNumber>;
                policy: z.ZodOptional<z.ZodNumber>;
                peerRecovery: z.ZodOptional<z.ZodNumber>;
                autoRecovery: z.ZodOptional<z.ZodNumber>;
                extendedManagement: z.ZodOptional<z.ZodNumber>;
                default: z.ZodOptional<z.ZodNumber>;
            }, "strict", z.ZodTypeAny, {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            }, {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            }>;
        }, "strip", z.ZodTypeAny, {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        }, {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            appletUid: z.ZodString;
            appletVersion: z.ZodString;
            startsAt: z.ZodOptional<z.ZodDate>;
            endsAt: z.ZodOptional<z.ZodDate>;
            configuration: z.ZodRecord<z.ZodString, z.ZodUnknown>;
            finishEvent: z.ZodOptional<z.ZodObject<{
                type: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType>;
                data: z.ZodOptional<z.ZodAny>;
            }, "strip", z.ZodTypeAny, {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            }, {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            }>>;
            position: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        }, {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            url: z.ZodNullable<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            url: string | null;
        }, {
            url: string | null;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
            name: z.ZodString;
            disabled: z.ZodOptional<z.ZodBoolean>;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodLiteral<"wifi">;
            wifiStrength: z.ZodOptional<z.ZodNumber>;
            wifiSsid: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        }, {
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        }>, z.ZodObject<{
            name: z.ZodString;
            disabled: z.ZodOptional<z.ZodBoolean>;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodLiteral<"ethernet">;
        }, "strip", z.ZodTypeAny, {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }, {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }>, z.ZodObject<{
            name: z.ZodString;
            disabled: z.ZodOptional<z.ZodBoolean>;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodLiteral<"vpn">;
        }, "strip", z.ZodTypeAny, {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }, {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }>, z.ZodObject<{
            name: z.ZodString;
            disabled: z.ZodOptional<z.ZodBoolean>;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodLiteral<"mobile">;
        }, "strip", z.ZodTypeAny, {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }, {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }>]>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            powerOn: z.ZodBoolean;
        }, "strict", z.ZodTypeAny, {
            powerOn: boolean;
        }, {
            powerOn: boolean;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>]>, "many">>;
}, "strict", z.ZodTypeAny, {
    name: string;
    type: "Policy.CreatePolicy";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    items?: ({
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    })[] | undefined;
}, {
    name: string;
    type: "Policy.CreatePolicy";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    items?: ({
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    })[] | undefined;
}>;
export type CreatePolicy = z.infer<typeof CreatePolicySchema>;
export declare const CreatePolicyFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    items?: ({
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    })[] | undefined;
} & {
    name: string;
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
} & Partial<import("../types").ObjectRecursiveIntersection<{
    name: string;
    type: "Policy.CreatePolicy";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    items?: ({
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    })[] | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Policy.CreatePolicy">;
    name: z.ZodString;
    organizationUid: z.ZodString;
    items: z.ZodOptional<z.ZodArray<z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            volume: z.ZodNumber;
        }, "strict", z.ZodTypeAny, {
            volume: number;
        }, {
            volume: number;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<{
            brightness: z.ZodNumber;
            time: z.ZodString;
        }, "strict", z.ZodTypeAny, {
            time: string;
            brightness: number;
        }, {
            time: string;
            brightness: number;
        }>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<{
            type: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType>;
            weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum>, "many">;
            timeOn: z.ZodNullable<z.ZodString>;
            timeOff: z.ZodNullable<z.ZodString>;
            volume: z.ZodNumber;
        }, "strict", z.ZodTypeAny, {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }, {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<{
            type: z.ZodType<`TIMER_${number}`, z.ZodTypeDef, `TIMER_${number}`>;
            weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum>, "many">;
            timeOn: z.ZodNullable<z.ZodString>;
            timeOff: z.ZodNullable<z.ZodString>;
            keepAppletRunning: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }, {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            width: z.ZodNumber;
            height: z.ZodNumber;
            framerate: z.ZodOptional<z.ZodNumber>;
        }, "strict", z.ZodTypeAny, {
            height: number;
            width: number;
            framerate?: number | undefined;
        }, {
            height: number;
            width: number;
            framerate?: number | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            orientation: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/Resolution/Orientation").default>;
            videoOrientation: z.ZodOptional<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default>>;
        }, "strict", z.ZodTypeAny, {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        }, {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
        }, {
            enabled: boolean;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            version: z.ZodString;
        }, "strict", z.ZodTypeAny, {
            version: string;
        }, {
            version: string;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            version: z.ZodString;
        }, "strict", z.ZodTypeAny, {
            version: string;
        }, {
            version: string;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            appletEnabled: z.ZodBoolean;
            nativeEnabled: z.ZodBoolean;
        }, "strict", z.ZodTypeAny, {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        }, {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            timezone: z.ZodNullable<z.ZodString>;
            ntpServer: z.ZodNullable<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            timezone: string | null;
            ntpServer: string | null;
        }, {
            timezone: string | null;
            ntpServer: string | null;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<{
            uid: z.ZodString;
            powerType: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/Power/PowerActionType").default>;
            weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum>, "many">;
            time: z.ZodString;
        }, "strict", z.ZodTypeAny, {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }, {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            temperatureLimit: z.ZodNumber;
        }, "strict", z.ZodTypeAny, {
            temperatureLimit: number;
        }, {
            temperatureLimit: number;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
            healthcheckIntervalMs: z.ZodOptional<z.ZodNumber>;
            autoEnableTimeoutMs: z.ZodOptional<z.ZodNumber>;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        }, {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
            urlLauncherAddress: z.ZodOptional<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        }, {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
            uri: z.ZodNullable<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
            uri: string | null;
        }, {
            enabled: boolean;
            uri: string | null;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodNullable<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/socketDriver").SocketDriver>>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            toInstall: z.ZodArray<z.ZodObject<{
                packageName: z.ZodString;
                ownerOrganizationUid: z.ZodString;
                buildHash: z.ZodString;
                version: z.ZodString;
                build: z.ZodNullable<z.ZodString>;
                applicationType: z.ZodLiteral<"android">;
                specs: z.ZodObject<{
                    packageName: z.ZodString;
                    sdkVersion: z.ZodNumber;
                    supportedAbis: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodEnum<["x86", "x86_64", "armeabi-v7a", "arm64-v8a"]>, z.ZodString]>, "many">>;
                    multiArch: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
                    versionCode: z.ZodOptional<z.ZodNumber>;
                    targetSdkVersion: z.ZodOptional<z.ZodNumber>;
                }, "strip", z.ZodTypeAny, {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                }, {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                }>;
            }, "strict", z.ZodTypeAny, {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }, {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }>, "many">;
            toUninstall: z.ZodArray<z.ZodObject<{
                packageName: z.ZodString;
                applicationType: z.ZodLiteral<"android">;
                specs: z.ZodObject<{
                    packageName: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    packageName: string;
                }, {
                    packageName: string;
                }>;
            }, "strict", z.ZodTypeAny, {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }, {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }>, "many">;
        }, "strip", z.ZodTypeAny, {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        }, {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            telemetryIntervals: z.ZodObject<{
                screenshots: z.ZodOptional<z.ZodNumber>;
                temperature: z.ZodOptional<z.ZodNumber>;
                applicationVersion: z.ZodOptional<z.ZodNumber>;
                frontDisplayVersion: z.ZodOptional<z.ZodNumber>;
                brightness: z.ZodOptional<z.ZodNumber>;
                datetime: z.ZodOptional<z.ZodNumber>;
                debug: z.ZodOptional<z.ZodNumber>;
                firmwareVersion: z.ZodOptional<z.ZodNumber>;
                orientation: z.ZodOptional<z.ZodNumber>;
                powerActionsSchedule: z.ZodOptional<z.ZodNumber>;
                proprietaryTimers: z.ZodOptional<z.ZodNumber>;
                remoteControl: z.ZodOptional<z.ZodNumber>;
                resolution: z.ZodOptional<z.ZodNumber>;
                timers: z.ZodOptional<z.ZodNumber>;
                volume: z.ZodOptional<z.ZodNumber>;
                storage: z.ZodOptional<z.ZodNumber>;
                battery: z.ZodOptional<z.ZodNumber>;
                policy: z.ZodOptional<z.ZodNumber>;
                peerRecovery: z.ZodOptional<z.ZodNumber>;
                autoRecovery: z.ZodOptional<z.ZodNumber>;
                extendedManagement: z.ZodOptional<z.ZodNumber>;
                default: z.ZodOptional<z.ZodNumber>;
            }, "strict", z.ZodTypeAny, {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            }, {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            }>;
        }, "strip", z.ZodTypeAny, {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        }, {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            appletUid: z.ZodString;
            appletVersion: z.ZodString;
            startsAt: z.ZodOptional<z.ZodDate>;
            endsAt: z.ZodOptional<z.ZodDate>;
            configuration: z.ZodRecord<z.ZodString, z.ZodUnknown>;
            finishEvent: z.ZodOptional<z.ZodObject<{
                type: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType>;
                data: z.ZodOptional<z.ZodAny>;
            }, "strip", z.ZodTypeAny, {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            }, {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            }>>;
            position: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        }, {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            url: z.ZodNullable<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            url: string | null;
        }, {
            url: string | null;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
            name: z.ZodString;
            disabled: z.ZodOptional<z.ZodBoolean>;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodLiteral<"wifi">;
            wifiStrength: z.ZodOptional<z.ZodNumber>;
            wifiSsid: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        }, {
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        }>, z.ZodObject<{
            name: z.ZodString;
            disabled: z.ZodOptional<z.ZodBoolean>;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodLiteral<"ethernet">;
        }, "strip", z.ZodTypeAny, {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }, {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }>, z.ZodObject<{
            name: z.ZodString;
            disabled: z.ZodOptional<z.ZodBoolean>;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodLiteral<"vpn">;
        }, "strip", z.ZodTypeAny, {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }, {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }>, z.ZodObject<{
            name: z.ZodString;
            disabled: z.ZodOptional<z.ZodBoolean>;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodLiteral<"mobile">;
        }, "strip", z.ZodTypeAny, {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }, {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }>]>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            powerOn: z.ZodBoolean;
        }, "strict", z.ZodTypeAny, {
            powerOn: boolean;
        }, {
            powerOn: boolean;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>]>, "many">>;
}, "strict", z.ZodTypeAny, {
    name: string;
    type: "Policy.CreatePolicy";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    items?: ({
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    })[] | undefined;
}, {
    name: string;
    type: "Policy.CreatePolicy";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    items?: ({
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    })[] | undefined;
}>>;
export declare const ClonePolicy = "Policy.ClonePolicy";
export declare const ClonePolicySchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Policy.ClonePolicy">;
    patternUid: z.ZodString;
    name: z.ZodString;
    organizationUid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    name: string;
    type: "Policy.ClonePolicy";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    patternUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    name: string;
    type: "Policy.ClonePolicy";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    patternUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type ClonePolicy = z.infer<typeof ClonePolicySchema>;
export declare const ClonePolicyFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    name: string;
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    patternUid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    name: string;
    type: "Policy.ClonePolicy";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    patternUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Policy.ClonePolicy">;
    patternUid: z.ZodString;
    name: z.ZodString;
    organizationUid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    name: string;
    type: "Policy.ClonePolicy";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    patternUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    name: string;
    type: "Policy.ClonePolicy";
    organizationUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    patternUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const UpdatePolicy = "Policy.UpdatePolicy";
export declare const UpdatePolicySchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Policy.UpdatePolicy">;
    uid: z.ZodString;
    items: z.ZodArray<z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            volume: z.ZodNumber;
        }, "strict", z.ZodTypeAny, {
            volume: number;
        }, {
            volume: number;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<{
            brightness: z.ZodNumber;
            time: z.ZodString;
        }, "strict", z.ZodTypeAny, {
            time: string;
            brightness: number;
        }, {
            time: string;
            brightness: number;
        }>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<{
            type: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType>;
            weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum>, "many">;
            timeOn: z.ZodNullable<z.ZodString>;
            timeOff: z.ZodNullable<z.ZodString>;
            volume: z.ZodNumber;
        }, "strict", z.ZodTypeAny, {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }, {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<{
            type: z.ZodType<`TIMER_${number}`, z.ZodTypeDef, `TIMER_${number}`>;
            weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum>, "many">;
            timeOn: z.ZodNullable<z.ZodString>;
            timeOff: z.ZodNullable<z.ZodString>;
            keepAppletRunning: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }, {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            width: z.ZodNumber;
            height: z.ZodNumber;
            framerate: z.ZodOptional<z.ZodNumber>;
        }, "strict", z.ZodTypeAny, {
            height: number;
            width: number;
            framerate?: number | undefined;
        }, {
            height: number;
            width: number;
            framerate?: number | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            orientation: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/Resolution/Orientation").default>;
            videoOrientation: z.ZodOptional<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default>>;
        }, "strict", z.ZodTypeAny, {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        }, {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
        }, {
            enabled: boolean;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            version: z.ZodString;
        }, "strict", z.ZodTypeAny, {
            version: string;
        }, {
            version: string;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            version: z.ZodString;
        }, "strict", z.ZodTypeAny, {
            version: string;
        }, {
            version: string;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            appletEnabled: z.ZodBoolean;
            nativeEnabled: z.ZodBoolean;
        }, "strict", z.ZodTypeAny, {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        }, {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            timezone: z.ZodNullable<z.ZodString>;
            ntpServer: z.ZodNullable<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            timezone: string | null;
            ntpServer: string | null;
        }, {
            timezone: string | null;
            ntpServer: string | null;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<{
            uid: z.ZodString;
            powerType: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/Power/PowerActionType").default>;
            weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum>, "many">;
            time: z.ZodString;
        }, "strict", z.ZodTypeAny, {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }, {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            temperatureLimit: z.ZodNumber;
        }, "strict", z.ZodTypeAny, {
            temperatureLimit: number;
        }, {
            temperatureLimit: number;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
            healthcheckIntervalMs: z.ZodOptional<z.ZodNumber>;
            autoEnableTimeoutMs: z.ZodOptional<z.ZodNumber>;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        }, {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
            urlLauncherAddress: z.ZodOptional<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        }, {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
            uri: z.ZodNullable<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
            uri: string | null;
        }, {
            enabled: boolean;
            uri: string | null;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodNullable<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/socketDriver").SocketDriver>>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            toInstall: z.ZodArray<z.ZodObject<{
                packageName: z.ZodString;
                ownerOrganizationUid: z.ZodString;
                buildHash: z.ZodString;
                version: z.ZodString;
                build: z.ZodNullable<z.ZodString>;
                applicationType: z.ZodLiteral<"android">;
                specs: z.ZodObject<{
                    packageName: z.ZodString;
                    sdkVersion: z.ZodNumber;
                    supportedAbis: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodEnum<["x86", "x86_64", "armeabi-v7a", "arm64-v8a"]>, z.ZodString]>, "many">>;
                    multiArch: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
                    versionCode: z.ZodOptional<z.ZodNumber>;
                    targetSdkVersion: z.ZodOptional<z.ZodNumber>;
                }, "strip", z.ZodTypeAny, {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                }, {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                }>;
            }, "strict", z.ZodTypeAny, {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }, {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }>, "many">;
            toUninstall: z.ZodArray<z.ZodObject<{
                packageName: z.ZodString;
                applicationType: z.ZodLiteral<"android">;
                specs: z.ZodObject<{
                    packageName: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    packageName: string;
                }, {
                    packageName: string;
                }>;
            }, "strict", z.ZodTypeAny, {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }, {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }>, "many">;
        }, "strip", z.ZodTypeAny, {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        }, {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            telemetryIntervals: z.ZodObject<{
                screenshots: z.ZodOptional<z.ZodNumber>;
                temperature: z.ZodOptional<z.ZodNumber>;
                applicationVersion: z.ZodOptional<z.ZodNumber>;
                frontDisplayVersion: z.ZodOptional<z.ZodNumber>;
                brightness: z.ZodOptional<z.ZodNumber>;
                datetime: z.ZodOptional<z.ZodNumber>;
                debug: z.ZodOptional<z.ZodNumber>;
                firmwareVersion: z.ZodOptional<z.ZodNumber>;
                orientation: z.ZodOptional<z.ZodNumber>;
                powerActionsSchedule: z.ZodOptional<z.ZodNumber>;
                proprietaryTimers: z.ZodOptional<z.ZodNumber>;
                remoteControl: z.ZodOptional<z.ZodNumber>;
                resolution: z.ZodOptional<z.ZodNumber>;
                timers: z.ZodOptional<z.ZodNumber>;
                volume: z.ZodOptional<z.ZodNumber>;
                storage: z.ZodOptional<z.ZodNumber>;
                battery: z.ZodOptional<z.ZodNumber>;
                policy: z.ZodOptional<z.ZodNumber>;
                peerRecovery: z.ZodOptional<z.ZodNumber>;
                autoRecovery: z.ZodOptional<z.ZodNumber>;
                extendedManagement: z.ZodOptional<z.ZodNumber>;
                default: z.ZodOptional<z.ZodNumber>;
            }, "strict", z.ZodTypeAny, {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            }, {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            }>;
        }, "strip", z.ZodTypeAny, {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        }, {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            appletUid: z.ZodString;
            appletVersion: z.ZodString;
            startsAt: z.ZodOptional<z.ZodDate>;
            endsAt: z.ZodOptional<z.ZodDate>;
            configuration: z.ZodRecord<z.ZodString, z.ZodUnknown>;
            finishEvent: z.ZodOptional<z.ZodObject<{
                type: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType>;
                data: z.ZodOptional<z.ZodAny>;
            }, "strip", z.ZodTypeAny, {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            }, {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            }>>;
            position: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        }, {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            url: z.ZodNullable<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            url: string | null;
        }, {
            url: string | null;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
            name: z.ZodString;
            disabled: z.ZodOptional<z.ZodBoolean>;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodLiteral<"wifi">;
            wifiStrength: z.ZodOptional<z.ZodNumber>;
            wifiSsid: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        }, {
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        }>, z.ZodObject<{
            name: z.ZodString;
            disabled: z.ZodOptional<z.ZodBoolean>;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodLiteral<"ethernet">;
        }, "strip", z.ZodTypeAny, {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }, {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }>, z.ZodObject<{
            name: z.ZodString;
            disabled: z.ZodOptional<z.ZodBoolean>;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodLiteral<"vpn">;
        }, "strip", z.ZodTypeAny, {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }, {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }>, z.ZodObject<{
            name: z.ZodString;
            disabled: z.ZodOptional<z.ZodBoolean>;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodLiteral<"mobile">;
        }, "strip", z.ZodTypeAny, {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }, {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }>]>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            powerOn: z.ZodBoolean;
        }, "strict", z.ZodTypeAny, {
            powerOn: boolean;
        }, {
            powerOn: boolean;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>]>, "many">;
    note: z.ZodOptional<z.ZodString>;
}, "strict", z.ZodTypeAny, {
    type: "Policy.UpdatePolicy";
    items: ({
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    })[];
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    note?: string | undefined;
}, {
    type: "Policy.UpdatePolicy";
    items: ({
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    })[];
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    note?: string | undefined;
}>;
export type UpdatePolicy = z.infer<typeof UpdatePolicySchema>;
export declare const UpdatePolicyFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    note?: string | undefined;
} & {
    items: ({
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    })[];
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Policy.UpdatePolicy";
    items: ({
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    })[];
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    note?: string | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Policy.UpdatePolicy">;
    uid: z.ZodString;
    items: z.ZodArray<z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            volume: z.ZodNumber;
        }, "strict", z.ZodTypeAny, {
            volume: number;
        }, {
            volume: number;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<{
            brightness: z.ZodNumber;
            time: z.ZodString;
        }, "strict", z.ZodTypeAny, {
            time: string;
            brightness: number;
        }, {
            time: string;
            brightness: number;
        }>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<{
            type: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType>;
            weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum>, "many">;
            timeOn: z.ZodNullable<z.ZodString>;
            timeOff: z.ZodNullable<z.ZodString>;
            volume: z.ZodNumber;
        }, "strict", z.ZodTypeAny, {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }, {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<{
            type: z.ZodType<`TIMER_${number}`, z.ZodTypeDef, `TIMER_${number}`>;
            weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum>, "many">;
            timeOn: z.ZodNullable<z.ZodString>;
            timeOff: z.ZodNullable<z.ZodString>;
            keepAppletRunning: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }, {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            width: z.ZodNumber;
            height: z.ZodNumber;
            framerate: z.ZodOptional<z.ZodNumber>;
        }, "strict", z.ZodTypeAny, {
            height: number;
            width: number;
            framerate?: number | undefined;
        }, {
            height: number;
            width: number;
            framerate?: number | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            orientation: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/Resolution/Orientation").default>;
            videoOrientation: z.ZodOptional<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default>>;
        }, "strict", z.ZodTypeAny, {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        }, {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
        }, {
            enabled: boolean;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            version: z.ZodString;
        }, "strict", z.ZodTypeAny, {
            version: string;
        }, {
            version: string;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            version: z.ZodString;
        }, "strict", z.ZodTypeAny, {
            version: string;
        }, {
            version: string;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            appletEnabled: z.ZodBoolean;
            nativeEnabled: z.ZodBoolean;
        }, "strict", z.ZodTypeAny, {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        }, {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            timezone: z.ZodNullable<z.ZodString>;
            ntpServer: z.ZodNullable<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            timezone: string | null;
            ntpServer: string | null;
        }, {
            timezone: string | null;
            ntpServer: string | null;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodObject<{
            uid: z.ZodString;
            powerType: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/Power/PowerActionType").default>;
            weekdays: z.ZodArray<z.ZodNativeEnum<typeof import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum>, "many">;
            time: z.ZodString;
        }, "strict", z.ZodTypeAny, {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }, {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            temperatureLimit: z.ZodNumber;
        }, "strict", z.ZodTypeAny, {
            temperatureLimit: number;
        }, {
            temperatureLimit: number;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
            healthcheckIntervalMs: z.ZodOptional<z.ZodNumber>;
            autoEnableTimeoutMs: z.ZodOptional<z.ZodNumber>;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        }, {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
            urlLauncherAddress: z.ZodOptional<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        }, {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            enabled: z.ZodBoolean;
            uri: z.ZodNullable<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            enabled: boolean;
            uri: string | null;
        }, {
            enabled: boolean;
            uri: string | null;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodNullable<z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Device/socketDriver").SocketDriver>>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            toInstall: z.ZodArray<z.ZodObject<{
                packageName: z.ZodString;
                ownerOrganizationUid: z.ZodString;
                buildHash: z.ZodString;
                version: z.ZodString;
                build: z.ZodNullable<z.ZodString>;
                applicationType: z.ZodLiteral<"android">;
                specs: z.ZodObject<{
                    packageName: z.ZodString;
                    sdkVersion: z.ZodNumber;
                    supportedAbis: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodEnum<["x86", "x86_64", "armeabi-v7a", "arm64-v8a"]>, z.ZodString]>, "many">>;
                    multiArch: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
                    versionCode: z.ZodOptional<z.ZodNumber>;
                    targetSdkVersion: z.ZodOptional<z.ZodNumber>;
                }, "strip", z.ZodTypeAny, {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                }, {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                }>;
            }, "strict", z.ZodTypeAny, {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }, {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }>, "many">;
            toUninstall: z.ZodArray<z.ZodObject<{
                packageName: z.ZodString;
                applicationType: z.ZodLiteral<"android">;
                specs: z.ZodObject<{
                    packageName: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    packageName: string;
                }, {
                    packageName: string;
                }>;
            }, "strict", z.ZodTypeAny, {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }, {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }>, "many">;
        }, "strip", z.ZodTypeAny, {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        }, {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            telemetryIntervals: z.ZodObject<{
                screenshots: z.ZodOptional<z.ZodNumber>;
                temperature: z.ZodOptional<z.ZodNumber>;
                applicationVersion: z.ZodOptional<z.ZodNumber>;
                frontDisplayVersion: z.ZodOptional<z.ZodNumber>;
                brightness: z.ZodOptional<z.ZodNumber>;
                datetime: z.ZodOptional<z.ZodNumber>;
                debug: z.ZodOptional<z.ZodNumber>;
                firmwareVersion: z.ZodOptional<z.ZodNumber>;
                orientation: z.ZodOptional<z.ZodNumber>;
                powerActionsSchedule: z.ZodOptional<z.ZodNumber>;
                proprietaryTimers: z.ZodOptional<z.ZodNumber>;
                remoteControl: z.ZodOptional<z.ZodNumber>;
                resolution: z.ZodOptional<z.ZodNumber>;
                timers: z.ZodOptional<z.ZodNumber>;
                volume: z.ZodOptional<z.ZodNumber>;
                storage: z.ZodOptional<z.ZodNumber>;
                battery: z.ZodOptional<z.ZodNumber>;
                policy: z.ZodOptional<z.ZodNumber>;
                peerRecovery: z.ZodOptional<z.ZodNumber>;
                autoRecovery: z.ZodOptional<z.ZodNumber>;
                extendedManagement: z.ZodOptional<z.ZodNumber>;
                default: z.ZodOptional<z.ZodNumber>;
            }, "strict", z.ZodTypeAny, {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            }, {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            }>;
        }, "strip", z.ZodTypeAny, {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        }, {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            appletUid: z.ZodString;
            appletVersion: z.ZodString;
            startsAt: z.ZodOptional<z.ZodDate>;
            endsAt: z.ZodOptional<z.ZodDate>;
            configuration: z.ZodRecord<z.ZodString, z.ZodUnknown>;
            finishEvent: z.ZodOptional<z.ZodObject<{
                type: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType>;
                data: z.ZodOptional<z.ZodAny>;
            }, "strip", z.ZodTypeAny, {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            }, {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            }>>;
            position: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        }, {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            url: z.ZodNullable<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            url: string | null;
        }, {
            url: string | null;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodArray<z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
            name: z.ZodString;
            disabled: z.ZodOptional<z.ZodBoolean>;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodLiteral<"wifi">;
            wifiStrength: z.ZodOptional<z.ZodNumber>;
            wifiSsid: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        }, {
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        }>, z.ZodObject<{
            name: z.ZodString;
            disabled: z.ZodOptional<z.ZodBoolean>;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodLiteral<"ethernet">;
        }, "strip", z.ZodTypeAny, {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }, {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }>, z.ZodObject<{
            name: z.ZodString;
            disabled: z.ZodOptional<z.ZodBoolean>;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodLiteral<"vpn">;
        }, "strip", z.ZodTypeAny, {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }, {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }>, z.ZodObject<{
            name: z.ZodString;
            disabled: z.ZodOptional<z.ZodBoolean>;
            macAddress: z.ZodEffects<z.ZodEffects<z.ZodString, string, string>, string, string>;
            gateway: z.ZodOptional<z.ZodString>;
            localAddress: z.ZodOptional<z.ZodString>;
            netmask: z.ZodOptional<z.ZodString>;
            dns: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodLiteral<"mobile">;
        }, "strip", z.ZodTypeAny, {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }, {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        }>]>, "many">;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON>;
        applicationType: z.ZodOptional<z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>>;
        value: z.ZodObject<{
            powerOn: z.ZodBoolean;
        }, "strict", z.ZodTypeAny, {
            powerOn: boolean;
        }, {
            powerOn: boolean;
        }>;
        updatedAt: z.ZodDefault<z.ZodDate>;
    }, "strict", z.ZodTypeAny, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    }, {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    }>]>, "many">;
    note: z.ZodOptional<z.ZodString>;
}, "strict", z.ZodTypeAny, {
    type: "Policy.UpdatePolicy";
    items: ({
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        updatedAt: Date;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
    })[];
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    note?: string | undefined;
}, {
    type: "Policy.UpdatePolicy";
    items: ({
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.VOLUME;
        value: {
            volume: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.BRIGHTNESS;
        value: {
            time: string;
            brightness: number;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TIMERS;
        value: {
            type: import("@signageos/common-types/dist/Device/Timer/NativeTimerType").NativeTimerType;
            volume: number;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROPRIETARY_TIMERS;
        value: {
            type: `TIMER_${number}`;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            timeOn: string | null;
            timeOff: string | null;
            keepAppletRunning?: boolean | undefined;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.RESOLUTION;
        value: {
            height: number;
            width: number;
            framerate?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.ORIENTATION;
        value: {
            orientation: import("@signageos/common-types/dist/Device/Resolution/Orientation").default;
            videoOrientation?: import("@signageos/common-types/dist/Device/Resolution/VideoOrientation").default | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.REMOTE_CONTROL;
        value: {
            enabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLICATION_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.FIRMWARE_VERSION;
        value: {
            version: string;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DEBUG;
        value: {
            appletEnabled: boolean;
            nativeEnabled: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DATETIME;
        value: {
            timezone: string | null;
            ntpServer: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.POWER_ACTIONS_SCHEDULE;
        value: {
            time: string;
            weekdays: import("@signageos/lib/dist/Timer/Power/PowerTimerWeekdayEnum").LongWeekdayEnum[];
            uid: string;
            powerType: import("@signageos/common-types/dist/Device/Power/PowerActionType").default;
        }[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TEMPERATURE;
        value: {
            temperatureLimit: number;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.AUTO_RECOVERY;
        value: {
            enabled: boolean;
            healthcheckIntervalMs?: number | undefined;
            autoEnableTimeoutMs?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PEER_RECOVERY;
        value: {
            enabled: boolean;
            urlLauncherAddress?: string | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PROXY;
        value: {
            enabled: boolean;
            uri: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.CONNECTION_METHOD;
        value: import("@signageos/common-types/dist/Device/socketDriver").SocketDriver | null;
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.PACKAGES;
        value: {
            toInstall: {
                packageName: string;
                applicationType: "android";
                ownerOrganizationUid: string;
                buildHash: string;
                version: string;
                build: string | null;
                specs: {
                    packageName: string;
                    sdkVersion: number;
                    supportedAbis?: string[] | undefined;
                    multiArch?: boolean | null | undefined;
                    versionCode?: number | undefined;
                    targetSdkVersion?: number | undefined;
                };
            }[];
            toUninstall: {
                packageName: string;
                applicationType: "android";
                specs: {
                    packageName: string;
                };
            }[];
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.TELEMETRY_INTERVALS;
        value: {
            telemetryIntervals: {
                screenshots?: number | undefined;
                temperature?: number | undefined;
                applicationVersion?: number | undefined;
                frontDisplayVersion?: number | undefined;
                brightness?: number | undefined;
                datetime?: number | undefined;
                debug?: number | undefined;
                firmwareVersion?: number | undefined;
                orientation?: number | undefined;
                powerActionsSchedule?: number | undefined;
                proprietaryTimers?: number | undefined;
                remoteControl?: number | undefined;
                resolution?: number | undefined;
                timers?: number | undefined;
                volume?: number | undefined;
                storage?: number | undefined;
                battery?: number | undefined;
                policy?: number | undefined;
                peerRecovery?: number | undefined;
                autoRecovery?: number | undefined;
                extendedManagement?: number | undefined;
                default?: number | undefined;
            };
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.APPLET;
        value: {
            appletUid: string;
            appletVersion: string;
            configuration: Record<string, unknown>;
            startsAt?: Date | undefined;
            endsAt?: Date | undefined;
            finishEvent?: {
                type: import("@signageos/common-types/dist/Timing/FinishEventType").FinishEventType;
                data?: any;
            } | undefined;
            position?: number | undefined;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.EXTENDED_MANAGEMENT;
        value: {
            url: string | null;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.NETWORK_INTERFACES;
        value: ({
            name: string;
            type: "wifi";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
            wifiStrength?: number | undefined;
            wifiSsid?: string | undefined;
        } | {
            name: string;
            type: "ethernet";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "vpn";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        } | {
            name: string;
            type: "mobile";
            macAddress: string;
            disabled?: boolean | undefined;
            gateway?: string | undefined;
            localAddress?: string | undefined;
            netmask?: string | undefined;
            dns?: string[] | undefined;
        })[];
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    } | {
        type: import("@signageos/common-types/dist/Device/Settings/DeviceSettingsType").DeviceSettingsType.DISPLAY_POWER_ON;
        value: {
            powerOn: boolean;
        };
        applicationType?: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos" | undefined;
        updatedAt?: Date | undefined;
    })[];
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    note?: string | undefined;
}>>;
export declare const UpdatePolicyName = "Policy.UpdatePolicyName";
export declare const UpdatePolicyNameSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Policy.UpdatePolicyName">;
    uid: z.ZodString;
    name: z.ZodString;
}, "strict", z.ZodTypeAny, {
    name: string;
    type: "Policy.UpdatePolicyName";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    name: string;
    type: "Policy.UpdatePolicyName";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type UpdatePolicyName = z.infer<typeof UpdatePolicyNameSchema>;
export declare const UpdatePolicyNameFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    name: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    name: string;
    type: "Policy.UpdatePolicyName";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Policy.UpdatePolicyName">;
    uid: z.ZodString;
    name: z.ZodString;
}, "strict", z.ZodTypeAny, {
    name: string;
    type: "Policy.UpdatePolicyName";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    name: string;
    type: "Policy.UpdatePolicyName";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const ArchivePolicy = "Policy.ArchivePolicy";
export declare const ArchivePolicySchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Policy.ArchivePolicy">;
    uid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Policy.ArchivePolicy";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Policy.ArchivePolicy";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type ArchivePolicy = z.infer<typeof ArchivePolicySchema>;
export declare const ArchivePolicyFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Policy.ArchivePolicy";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Policy.ArchivePolicy">;
    uid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Policy.ArchivePolicy";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Policy.ArchivePolicy";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const UnarchivePolicy = "Policy.UnarchivePolicy";
export declare const UnarchivePolicySchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Policy.UnarchivePolicy">;
    uid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Policy.UnarchivePolicy";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Policy.UnarchivePolicy";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type UnarchivePolicy = z.infer<typeof UnarchivePolicySchema>;
export declare const UnarchivePolicyFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Policy.UnarchivePolicy";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Policy.UnarchivePolicy">;
    uid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Policy.UnarchivePolicy";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Policy.UnarchivePolicy";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
