"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdatePackageVersionSpecsFactory = exports.UpdatePackageVersionSpecsSchema = exports.UpdatePackageVersionSpecs = exports.UnreleasePackageVersion = exports.ReleasePackageVersion = exports.DeletePackageVersion = exports.CreatePackageVersion = exports.AndroidSpecsSchema = void 0;
const ICommand_1 = require("../ICommand");
const zod_1 = require("zod");
const commandFactory_1 = require("../commandFactory");
const packageVersionSpecsType_1 = require("@signageos/common-types/dist/Package/packageVersionSpecsType");
exports.AndroidSpecsSchema = packageVersionSpecsType_1.AndroidSpecsSchema.strict();
exports.CreatePackageVersion = 'Package.PackageVersion.Create';
exports.DeletePackageVersion = 'Package.PackageVersion.Delete';
exports.ReleasePackageVersion = 'Package.PackageVersion.Release';
exports.UnreleasePackageVersion = 'Package.PackageVersion.Unrelease';
/**
 * Command to update package version specs
 * only for admin users
 * will update only specified fields in `specs`
 */
exports.UpdatePackageVersionSpecs = 'Package.PackageVersion.UpdateSpecs';
exports.UpdatePackageVersionSpecsSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.UpdatePackageVersionSpecs),
    uid: zod_1.z.string(),
    specs: exports.AndroidSpecsSchema.partial(),
}).strict();
exports.UpdatePackageVersionSpecsFactory = (0, commandFactory_1.createCommandFactory)(exports.UpdatePackageVersionSpecsSchema);
//# sourceMappingURL=packageVersionCommands.js.map