import { IOriginatorAwareCommand } from '../ICommand';
import ApplicationType from '@signageos/common-types/dist/Application/ApplicationType';
import { z } from 'zod';
import { Abi as CommonAbi } from '@signageos/common-types/dist/Package/packageVersionSpecsType';
/** @deprecated Use {@link CommonAbi} instead */
export type Abi = CommonAbi;
export declare const AndroidSpecsSchema: z.ZodObject<{
    packageName: import("zod").ZodString;
    sdkVersion: import("zod").ZodNumber;
    supportedAbis: import("zod").ZodOptional<import("zod").ZodArray<import("zod").ZodUnion<[import("zod").ZodEnum<["x86", "x86_64", "armeabi-v7a", "arm64-v8a"]>, import("zod").ZodString]>, "many">>;
    multiArch: import("zod").ZodOptional<import("zod").ZodNullable<import("zod").ZodBoolean>>;
    versionCode: import("zod").ZodOptional<import("zod" /**
     * Contains unique hash (usually checksum of package file) which is unique for every build
     * E.g.:
     * Android - apk file sha256 (equal to specs.apkSha256)
     * TODO other platforms
     */).ZodNumber>;
    targetSdkVersion: import("zod").ZodOptional<import("zod").ZodNumber>;
}, "strict", z.ZodTypeAny, {
    packageName: string;
    sdkVersion: number;
    supportedAbis?: string[] | undefined;
    multiArch?: boolean | null | undefined;
    versionCode?: number | undefined;
    targetSdkVersion?: number | undefined;
}, {
    packageName: string;
    sdkVersion: number;
    supportedAbis?: string[] | undefined;
    multiArch?: boolean | null | undefined;
    versionCode?: number | undefined;
    targetSdkVersion?: number | undefined;
}>;
export type IAndroidSpecs = z.infer<typeof AndroidSpecsSchema>;
export declare const CreatePackageVersion = "Package.PackageVersion.Create";
export interface CreatePackageVersion extends IOriginatorAwareCommand<typeof CreatePackageVersion> {
    uid: string;
    packageName: string;
    applicationType: ApplicationType;
    /**
     * Contains unique hash (usually checksum of package file) which is unique for every build
     * E.g.:
     * Android - apk file sha256 (equal to specs.apkSha256)
     * TODO other platforms
     */
    buildHash: string;
    /**
     * Human readable version name
     * It's usually uniq for package real version but usually it's same for different builds (architectures)
     */
    version: string;
    /**
     * Additional human readable name postfix
     * its optional and can contain architecture or another string
     */
    build: string | null;
    /**
     * URL of the application icon extracted from APK archive
     */
    iconUrl: string | null;
    specs: IAndroidSpecs;
}
export declare const DeletePackageVersion = "Package.PackageVersion.Delete";
export interface DeletePackageVersion extends IOriginatorAwareCommand<typeof DeletePackageVersion> {
    uid: string;
}
export declare const ReleasePackageVersion = "Package.PackageVersion.Release";
export interface ReleasePackageVersion extends IOriginatorAwareCommand<typeof ReleasePackageVersion> {
    uid: string;
}
export declare const UnreleasePackageVersion = "Package.PackageVersion.Unrelease";
export interface UnreleasePackageVersion extends IOriginatorAwareCommand<typeof UnreleasePackageVersion> {
    uid: string;
}
/**
 * Command to update package version specs
 * only for admin users
 * will update only specified fields in `specs`
 */
export declare const UpdatePackageVersionSpecs = "Package.PackageVersion.UpdateSpecs";
export declare const UpdatePackageVersionSpecsSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Package.PackageVersion.UpdateSpecs">;
    uid: z.ZodString;
    specs: z.ZodObject<{
        packageName: z.ZodOptional<z.ZodString>;
        sdkVersion: z.ZodOptional<z.ZodNumber>;
        supportedAbis: z.ZodOptional<z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodEnum<["x86", "x86_64", "armeabi-v7a", "arm64-v8a"]>, z.ZodString]>, "many">>>;
        multiArch: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodBoolean>>>;
        versionCode: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
        targetSdkVersion: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
    }, "strict", z.ZodTypeAny, {
        packageName?: string | undefined;
        sdkVersion?: number | undefined;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    }, {
        packageName?: string | undefined;
        sdkVersion?: number | undefined;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    }>;
}, "strict", z.ZodTypeAny, {
    type: "Package.PackageVersion.UpdateSpecs";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    specs: {
        packageName?: string | undefined;
        sdkVersion?: number | undefined;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Package.PackageVersion.UpdateSpecs";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    specs: {
        packageName?: string | undefined;
        sdkVersion?: number | undefined;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type UpdatePackageVersionSpecs = z.infer<typeof UpdatePackageVersionSpecsSchema>;
export declare const UpdatePackageVersionSpecsFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    specs: {
        packageName?: string | undefined;
        sdkVersion?: number | undefined;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    };
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Package.PackageVersion.UpdateSpecs";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    specs: {
        packageName?: string | undefined;
        sdkVersion?: number | undefined;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Package.PackageVersion.UpdateSpecs">;
    uid: z.ZodString;
    specs: z.ZodObject<{
        packageName: z.ZodOptional<z.ZodString>;
        sdkVersion: z.ZodOptional<z.ZodNumber>;
        supportedAbis: z.ZodOptional<z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodEnum<["x86", "x86_64", "armeabi-v7a", "arm64-v8a"]>, z.ZodString]>, "many">>>;
        multiArch: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodBoolean>>>;
        versionCode: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
        targetSdkVersion: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
    }, "strict", z.ZodTypeAny, {
        packageName?: string | undefined;
        sdkVersion?: number | undefined;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    }, {
        packageName?: string | undefined;
        sdkVersion?: number | undefined;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    }>;
}, "strict", z.ZodTypeAny, {
    type: "Package.PackageVersion.UpdateSpecs";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    specs: {
        packageName?: string | undefined;
        sdkVersion?: number | undefined;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Package.PackageVersion.UpdateSpecs";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    specs: {
        packageName?: string | undefined;
        sdkVersion?: number | undefined;
        supportedAbis?: string[] | undefined;
        multiArch?: boolean | null | undefined;
        versionCode?: number | undefined;
        targetSdkVersion?: number | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
