import { z } from 'zod';
import { SubscriptionType } from '@signageos/common-types/dist/Subscription/subscription';
import { IOriginatorAwareCommand } from '../ICommand';
import { LocationMarker } from '@signageos/common-types/dist/Location/location';
export declare const OrganizationUIDSchema: z.ZodUnion<[z.ZodString, z.ZodString]>;
/**
 * Create new organization
 */
export declare const CreateOrganization = "Organization.CreateOrganization";
export declare const CreateOrganizationSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Organization.CreateOrganization">;
    uid: z.ZodString;
    companyUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    name: z.ZodString;
    title: z.ZodString;
    subscriptionType: z.ZodNativeEnum<typeof SubscriptionType>;
    iconUrl: z.ZodOptional<z.ZodString>;
}, "strict", z.ZodTypeAny, {
    name: string;
    type: "Organization.CreateOrganization";
    title: string;
    accountId: number;
    companyUid: string;
    uid: string;
    subscriptionType: SubscriptionType;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    iconUrl?: string | undefined;
}, {
    name: string;
    type: "Organization.CreateOrganization";
    title: string;
    accountId: string | number;
    companyUid: string;
    uid: string;
    subscriptionType: SubscriptionType;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    iconUrl?: string | undefined;
}>;
export type CreateOrganization = z.infer<typeof CreateOrganizationSchema>;
export declare const CreateOrganizationFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    iconUrl?: string | undefined;
} & {
    name: string;
    title: string;
    accountId: string | number;
    companyUid: string;
    subscriptionType: SubscriptionType;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    name: string;
    type: "Organization.CreateOrganization";
    title: string;
    accountId: number;
    companyUid: string;
    uid: string;
    subscriptionType: SubscriptionType;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    iconUrl?: string | undefined;
}, {
    uid: () => string;
}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Organization.CreateOrganization">;
    uid: z.ZodString;
    companyUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    name: z.ZodString;
    title: z.ZodString;
    subscriptionType: z.ZodNativeEnum<typeof SubscriptionType>;
    iconUrl: z.ZodOptional<z.ZodString>;
}, "strict", z.ZodTypeAny, {
    name: string;
    type: "Organization.CreateOrganization";
    title: string;
    accountId: number;
    companyUid: string;
    uid: string;
    subscriptionType: SubscriptionType;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    iconUrl?: string | undefined;
}, {
    name: string;
    type: "Organization.CreateOrganization";
    title: string;
    accountId: string | number;
    companyUid: string;
    uid: string;
    subscriptionType: SubscriptionType;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    iconUrl?: string | undefined;
}>>;
/**
 * Update existing organization
 */
export declare const UpdateOrganization = "Organization.UpdateOrganization";
export declare const UpdateOrganizationSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.UpdateOrganization">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    title: z.ZodOptional<z.ZodString>;
    iconUrl: z.ZodUnion<[z.ZodOptional<z.ZodString>, z.ZodNull]>;
    locationDefaultMarker: z.ZodOptional<z.ZodUnion<[z.ZodNativeEnum<typeof LocationMarker>, z.ZodNull]>>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.UpdateOrganization";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    title?: string | undefined;
    iconUrl?: string | null | undefined;
    locationDefaultMarker?: LocationMarker | null | undefined;
}, {
    type: "Organization.UpdateOrganization";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    title?: string | undefined;
    iconUrl?: string | null | undefined;
    locationDefaultMarker?: LocationMarker | null | undefined;
}>;
export type UpdateOrganization = z.infer<typeof UpdateOrganizationSchema>;
export declare const UpdateOrganizationFactory: (data: {
    title?: string | undefined;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    iconUrl?: string | null | undefined;
    locationDefaultMarker?: LocationMarker | null | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Organization.UpdateOrganization";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    title?: string | undefined;
    iconUrl?: string | null | undefined;
    locationDefaultMarker?: LocationMarker | null | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.UpdateOrganization">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    title: z.ZodOptional<z.ZodString>;
    iconUrl: z.ZodUnion<[z.ZodOptional<z.ZodString>, z.ZodNull]>;
    locationDefaultMarker: z.ZodOptional<z.ZodUnion<[z.ZodNativeEnum<typeof LocationMarker>, z.ZodNull]>>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.UpdateOrganization";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    title?: string | undefined;
    iconUrl?: string | null | undefined;
    locationDefaultMarker?: LocationMarker | null | undefined;
}, {
    type: "Organization.UpdateOrganization";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    title?: string | undefined;
    iconUrl?: string | null | undefined;
    locationDefaultMarker?: LocationMarker | null | undefined;
}>>;
export type ChangeOrganizationSubscriptionType = 'Organization.ChangeOrganizationSubscriptionType';
export declare const ChangeOrganizationSubscription: ChangeOrganizationSubscriptionType;
export interface ChangeOrganizationSubscription extends IOriginatorAwareCommand<ChangeOrganizationSubscriptionType> {
    uid: string;
    subscriptionType: SubscriptionType;
}
export type DeleteOrganizationType = 'Organization.DeleteOrganization';
export declare const DeleteOrganization: DeleteOrganizationType;
export interface DeleteOrganization extends IOriginatorAwareCommand<DeleteOrganizationType> {
    uid: string;
}
export type ToggleOrganizationProductionStateType = 'Organization.ToggleOrganizationProductionState';
export declare const ToggleOrganizationProductionState: ToggleOrganizationProductionStateType;
export interface ToggleOrganizationProductionState extends IOriginatorAwareCommand<ToggleOrganizationProductionStateType> {
    uid: string;
}
export type SetOrganizationParentalCompanyType = 'Organization.SetOrganizationParentalCompanyType';
export declare const SetOrganizationParentalCompany: SetOrganizationParentalCompanyType;
export interface SetOrganizationParentalCompany extends IOriginatorAwareCommand<SetOrganizationParentalCompanyType> {
    uid: string;
    parentalCompanyUid: string | null;
}
export type SetMaxDevicesCountType = 'Organization.SetMaxDevicesCount';
export declare const SetMaxDevicesCount: SetMaxDevicesCountType;
export interface SetMaxDevicesCount extends IOriginatorAwareCommand<SetMaxDevicesCountType> {
    uid: string;
    maxDevicesCount: number;
}
export declare const SetEndOfTrialPeriod = "Organization.SetEndOfTrialPeriod";
export interface SetEndOfTrialPeriod extends IOriginatorAwareCommand<typeof SetEndOfTrialPeriod> {
    uid: string;
    endDate: Date;
}
export declare const ClearEndOfTrialPeriod = "Organization.ClearEndOfTrialPeriod";
export interface ClearEndOfTrialPeriod extends IOriginatorAwareCommand<typeof ClearEndOfTrialPeriod> {
    uid: string;
}
export declare const SetOrganizationReporters = "Organization.SetOrganizationReporters";
export declare const SetOrganizationReportersSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.SetOrganizationReporters">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    reporters: z.ZodObject<{
        adobe: z.ZodOptional<z.ZodObject<{
            registrationKey: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            registrationKey: string;
        }, {
            registrationKey: string;
        }>>;
    }, "strip", z.ZodTypeAny, {
        adobe?: {
            registrationKey: string;
        } | undefined;
    }, {
        adobe?: {
            registrationKey: string;
        } | undefined;
    }>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.SetOrganizationReporters";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    reporters: {
        adobe?: {
            registrationKey: string;
        } | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Organization.SetOrganizationReporters";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    reporters: {
        adobe?: {
            registrationKey: string;
        } | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type SetOrganizationReporters = z.infer<typeof SetOrganizationReportersSchema>;
export declare const SetOrganizationReporterFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    reporters: {
        adobe?: {
            registrationKey: string;
        } | undefined;
    };
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Organization.SetOrganizationReporters";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    reporters: {
        adobe?: {
            registrationKey: string;
        } | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.SetOrganizationReporters">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    reporters: z.ZodObject<{
        adobe: z.ZodOptional<z.ZodObject<{
            registrationKey: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            registrationKey: string;
        }, {
            registrationKey: string;
        }>>;
    }, "strip", z.ZodTypeAny, {
        adobe?: {
            registrationKey: string;
        } | undefined;
    }, {
        adobe?: {
            registrationKey: string;
        } | undefined;
    }>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.SetOrganizationReporters";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    reporters: {
        adobe?: {
            registrationKey: string;
        } | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Organization.SetOrganizationReporters";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    reporters: {
        adobe?: {
            registrationKey: string;
        } | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const SetOrganizationVpn = "Organization.SetOrganizationVpn";
export declare const SetOrganizationVpnSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.SetOrganizationVpn">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    serverNameTag: z.ZodOptional<z.ZodString>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.SetOrganizationVpn";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    serverNameTag?: string | undefined;
}, {
    type: "Organization.SetOrganizationVpn";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    serverNameTag?: string | undefined;
}>;
export type SetOrganizationVpn = z.infer<typeof SetOrganizationVpnSchema>;
export declare const SetOrganizationVpnFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    serverNameTag?: string | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Organization.SetOrganizationVpn";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    serverNameTag?: string | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.SetOrganizationVpn">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    serverNameTag: z.ZodOptional<z.ZodString>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.SetOrganizationVpn";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    serverNameTag?: string | undefined;
}, {
    type: "Organization.SetOrganizationVpn";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    serverNameTag?: string | undefined;
}>>;
export declare const CreateOrganizationUserVPNConfig = "Organization.CreateOrganizationUserVPNConfig";
export declare const CreateOrganizationUserVPNConfigSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.CreateOrganizationUserVPNConfig">;
    uid: z.ZodString;
    orgUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.CreateOrganizationUserVPNConfig";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    orgUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Organization.CreateOrganizationUserVPNConfig";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    orgUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type CreateOrganizationUserVPNConfig = z.infer<typeof CreateOrganizationUserVPNConfigSchema>;
export declare const CreateOrganizationUserVPNConfigFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    orgUid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Organization.CreateOrganizationUserVPNConfig";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    orgUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    uid: () => string;
}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.CreateOrganizationUserVPNConfig">;
    uid: z.ZodString;
    orgUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.CreateOrganizationUserVPNConfig";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    orgUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Organization.CreateOrganizationUserVPNConfig";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    orgUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const RevokeOrganizationUserVPNConfig = "Organization.RevokeOrganizationUserVPNConfig";
export declare const RevokeOrganizationUserVPNConfigSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.RevokeOrganizationUserVPNConfig">;
    uid: z.ZodString;
    orgUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.RevokeOrganizationUserVPNConfig";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    orgUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Organization.RevokeOrganizationUserVPNConfig";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    orgUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type RevokeOrganizationUserVPNConfig = z.infer<typeof RevokeOrganizationUserVPNConfigSchema>;
export declare const RevokeOrganizationUserVPNConfigFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    orgUid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Organization.RevokeOrganizationUserVPNConfig";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    orgUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.RevokeOrganizationUserVPNConfig">;
    uid: z.ZodString;
    orgUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.RevokeOrganizationUserVPNConfig";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    orgUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Organization.RevokeOrganizationUserVPNConfig";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    orgUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export type ArchiveOrganizationType = 'Organization.ArchiveOrganization';
export declare const ArchiveOrganization: ArchiveOrganizationType;
export declare const ArchiveOrganizationSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.ArchiveOrganization">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.ArchiveOrganization";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Organization.ArchiveOrganization";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type ArchiveOrganization = z.infer<typeof ArchiveOrganizationSchema>;
export declare const ArchiveOrganizationFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Organization.ArchiveOrganization";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.ArchiveOrganization">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.ArchiveOrganization";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Organization.ArchiveOrganization";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export type UnarchiveOrganizationType = 'Organization.UnarchiveOrganization';
export declare const UnarchiveOrganization: UnarchiveOrganizationType;
export declare const UnarchiveOrganizationSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.UnarchiveOrganization">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.UnarchiveOrganization";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Organization.UnarchiveOrganization";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type UnarchiveOrganization = z.infer<typeof UnarchiveOrganizationSchema>;
export declare const UnarchiveOrganizationFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Organization.UnarchiveOrganization";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Organization.UnarchiveOrganization">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "Organization.UnarchiveOrganization";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Organization.UnarchiveOrganization";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
