"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnarchiveCompanyFactory = exports.UnarchiveCompanySchema = exports.UnarchiveCompany = exports.ArchiveCompanyFactory = exports.ArchiveCompanySchema = exports.ArchiveCompany = exports.SetDeviceNameTemplate = exports.SetCompanyDefaultSubscription = exports.DeleteCompany = exports.UpdateCompanyBillingPlan = exports.UpdateCompanyBillingInfo = exports.UpdateCompanyFactory = exports.UpdateCompanySchema = exports.UpdateCompany = exports.CreateCompanyFactory = exports.CreateCompanySchema = exports.CreateCompany = exports.CompanyUIDSchema = void 0;
const zod_1 = require("zod");
const Account_1 = require("@signageos/common-types/dist/Account/Account");
const string_1 = require("@signageos/lib/dist/String/string");
const Billing_1 = require("@signageos/common-types/dist/Billing/Billing");
const ICommand_1 = require("../ICommand");
const schemas_1 = require("../schemas");
const commandFactory_1 = require("../commandFactory");
const accountCommands_1 = require("../Account/accountCommands");
const Company_1 = require("@signageos/common-types/dist/Company/Company");
const License_1 = require("@signageos/common-types/dist/License/License");
const generators_1 = require("../generators");
exports.CompanyUIDSchema = schemas_1.UIDSchema.or(schemas_1.LegacyUIDSchema);
exports.CreateCompany = 'Organization.CreateCompany';
exports.CreateCompanySchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.CreateCompany),
    companyUid: schemas_1.UIDSchema, // Prevent creating organization with legacy uid
    accountId: accountCommands_1.AccountIdSchema,
    name: zod_1.z.string().min(2).max(255).regex(string_1.SUB_DOMAIN_SEGMENT_REG_EXP, {
        message: 'Name can contain only letters, numbers divided by dashes. It must start and end with a letter or a number.',
    }),
    title: zod_1.z.string().min(1).max(255),
    billingPlan: zod_1.z.nativeEnum(Billing_1.BillingPlan),
    /**
     * Custom icon for Company, it is optional and can be added later by user
     */
    iconUrl: zod_1.z.string().optional(),
    licenses: Company_1.CompanyLicensesSchema.default({ [License_1.License.DevSpace]: { users: 1, appBuildsPerMonth: 5 } }),
    /**
     * UID for company's first autogenerated organization
     */
    organizationUid: schemas_1.UIDSchema.optional(),
    /**
     * Postfix for creating company's first autogenerated organization from the company's title
     */
    organizationTitlePostfix: zod_1.z.string().default(' test organization'),
    /**
     * Trial period in days for the first autogenerated organization
     */
    trialPeriodDuration: zod_1.z.number().default(30),
    /**
     * Temporary command version to provide conditional execution in Command Handler
     */
    commandTempVersion: zod_1.z.number().default(2),
});
exports.CreateCompanyFactory = (0, commandFactory_1.createCommandFactory)(exports.CreateCompanySchema, { organizationUid: generators_1.uid });
exports.UpdateCompany = 'Organization.UpdateCompany';
/**
 * @defaultAccountRole null mean unset
 */
exports.UpdateCompanySchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.UpdateCompany),
    companyUid: exports.CompanyUIDSchema,
    title: zod_1.z.string().min(1).max(255).optional(),
    emailDomains: zod_1.z.array(zod_1.z.string()).optional(),
    defaultAccountRole: Account_1.RoleSchema.nullable().optional(),
    /**
     * Custom icon for Company
     */
    iconUrl: zod_1.z.string().optional(),
    licenses: Company_1.CompanyLicensesSchema.nullable().optional(),
});
exports.UpdateCompanyFactory = (0, commandFactory_1.createCommandFactory)(exports.UpdateCompanySchema, {});
exports.UpdateCompanyBillingInfo = 'Organization.UpdateCompanyBillingInfo';
exports.UpdateCompanyBillingPlan = 'Organization.UpdateCompanyBillingPlan';
exports.DeleteCompany = 'Organization.DeleteCompany';
exports.SetCompanyDefaultSubscription = 'Organization.SetCompanyDefaultSubscription';
exports.SetDeviceNameTemplate = 'Organization.SetDeviceNameTemplate';
exports.ArchiveCompany = 'Organization.ArchiveCompany';
exports.ArchiveCompanySchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.ArchiveCompany),
    companyUid: exports.CompanyUIDSchema,
});
exports.ArchiveCompanyFactory = (0, commandFactory_1.createCommandFactory)(exports.ArchiveCompanySchema, {});
exports.UnarchiveCompany = 'Organization.UnarchiveCompany';
exports.UnarchiveCompanySchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.UnarchiveCompany),
    companyUid: exports.CompanyUIDSchema,
});
exports.UnarchiveCompanyFactory = (0, commandFactory_1.createCommandFactory)(exports.UnarchiveCompanySchema, {});
//# sourceMappingURL=companyCommands.js.map