import ICommand from '../ICommand';
import { EmailType } from '@signageos/common-types/dist/Email/EmailType';
export declare const SendEmail = "Email.SendEmail";
export interface SendEmail extends ICommand<typeof SendEmail> {
    /**
     * Email address of the recipient.
     */
    recipient: string;
    /**
     * Full name of the recipient.
     */
    recipientName: string;
    /**
     * Email address of the sender.
     */
    sender: string;
    /**
     * Full name of the sender.
     */
    senderName: string;
    /**
     * Email address to reply to.
     */
    replyTo: string;
    /**
     * Full name of a person to reply to.
     */
    replyToName: string;
    /**
     * Subject of the email.
     */
    subject: string;
    /**
     * Plain text body of the email.
     */
    bodyText: string;
    /**
     * HTML body of the email.
     */
    bodyHtml: string;
    /**
     * Priority of the email.
     */
    priority: number;
    /**
     * Headers to be sent along with the email.
     */
    headers?: {
        [key: string]: string;
    };
    /**
     * Type of the email
     */
    emailType?: EmailType;
}
