"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteLocationFactory = exports.DeleteLocationSchema = exports.DeleteLocation = exports.UnarchiveLocationFactory = exports.UnarchiveLocationSchema = exports.UnarchiveLocation = exports.ArchiveLocationFactory = exports.ArchiveLocationSchema = exports.ArchiveLocation = exports.UpdateLocationFactory = exports.UpdateLocationSchema = exports.UpdateLocation = exports.CreateLocationFactory = exports.CreateLocationSchema = exports.CreateLocation = exports.FeatureSchema = exports.LocationUidSchema = void 0;
const zod_1 = require("zod");
const ICommand_1 = require("../ICommand");
const schemas_1 = require("../schemas");
const organizationCommands_1 = require("../Organization/organizationCommands");
const commandFactory_1 = require("../commandFactory");
const generators_1 = require("../generators");
const location_1 = require("@signageos/common-types/dist/Location/location");
exports.LocationUidSchema = schemas_1.UIDSchema.or(schemas_1.LegacyUIDSchema);
const BBoxSchema = zod_1.z
    .tuple([zod_1.z.number(), zod_1.z.number(), zod_1.z.number(), zod_1.z.number(), zod_1.z.number(), zod_1.z.number()])
    .or(zod_1.z.tuple([zod_1.z.number(), zod_1.z.number(), zod_1.z.number(), zod_1.z.number()]));
exports.FeatureSchema = zod_1.z.object({
    type: zod_1.z.literal('Feature'),
    geometry: zod_1.z.object({
        type: zod_1.z.literal('Point'),
        coordinates: zod_1.z.array(zod_1.z.number()),
        bbox: BBoxSchema.optional(),
        interpolated: zod_1.z.boolean().optional(),
        omitted: zod_1.z.boolean().optional(),
    }),
    id: zod_1.z.number().or(zod_1.z.string()).optional(),
    properties: zod_1.z.record(zod_1.z.any()).nullable(),
    bbox: BBoxSchema.optional(),
    label: zod_1.z.string().optional(),
    value: zod_1.z.string().optional(),
});
const LocationUpdatableSchema = zod_1.z.strictObject({
    name: zod_1.z.string().min(1).max(255),
    feature: exports.FeatureSchema,
    organizationUid: organizationCommands_1.OrganizationUIDSchema,
    city: zod_1.z.string().min(1).max(255),
    countryCode: zod_1.z.string().min(1).max(255),
    customId: zod_1.z.string().min(1).max(256).nullable().optional(),
    attachments: zod_1.z.array(zod_1.z.string().min(1).max(4096)).optional(),
    description: zod_1.z.string().max(4096).nullable().optional(),
    tagUids: zod_1.z.array(schemas_1.UIDSchema.or(schemas_1.LegacyUIDSchema)).optional(),
    mapMarker: zod_1.z.nativeEnum(location_1.LocationMarker).or(zod_1.z.null()).optional(),
});
exports.CreateLocation = 'Location.CreateLocation';
exports.CreateLocationSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.CreateLocation),
    uid: exports.LocationUidSchema,
}).extend(LocationUpdatableSchema.shape);
exports.CreateLocationFactory = (0, commandFactory_1.createCommandFactory)(exports.CreateLocationSchema, { uid: generators_1.uid });
exports.UpdateLocation = 'Location.UpdateLocation';
exports.UpdateLocationSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.UpdateLocation),
    uid: exports.LocationUidSchema,
}).extend(LocationUpdatableSchema.partial().shape);
exports.UpdateLocationFactory = (0, commandFactory_1.createCommandFactory)(exports.UpdateLocationSchema);
exports.ArchiveLocation = 'Location.ArchiveLocation';
exports.ArchiveLocationSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.ArchiveLocation),
    uid: exports.LocationUidSchema,
});
exports.ArchiveLocationFactory = (0, commandFactory_1.createCommandFactory)(exports.ArchiveLocationSchema);
exports.UnarchiveLocation = 'Location.UnarchiveLocation';
exports.UnarchiveLocationSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.UnarchiveLocation),
    uid: exports.LocationUidSchema,
});
exports.UnarchiveLocationFactory = (0, commandFactory_1.createCommandFactory)(exports.UnarchiveLocationSchema);
exports.DeleteLocation = 'Location.DeleteLocation';
exports.DeleteLocationSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.DeleteLocation),
    uid: exports.LocationUidSchema,
});
exports.DeleteLocationFactory = (0, commandFactory_1.createCommandFactory)(exports.DeleteLocationSchema);
//# sourceMappingURL=locationCommands.js.map