import { z } from 'zod';
interface ICommand<Type extends string> {
    type: Type;
}
export declare const BaseCommandSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
}, "strict", z.ZodTypeAny, {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type BaseCommand = z.infer<typeof BaseCommandSchema>;
export declare const OriginatorSchema: z.ZodObject<{
    accountId: z.ZodOptional<z.ZodNumber>;
    organizationUid: z.ZodOptional<z.ZodString>;
}, "strict", z.ZodTypeAny, {
    accountId?: number | undefined;
    organizationUid?: string | undefined;
}, {
    accountId?: number | undefined;
    organizationUid?: string | undefined;
}>;
export declare const OriginatorAwareCommandSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
}, "strict", z.ZodTypeAny, {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type TOriginatorAwareCommand = z.infer<typeof OriginatorAwareCommandSchema>;
/**
 * @deprecated use OriginatorAwareCommandSchema (zod) instead without generics. As it is more strict and have run time validation
 */
export interface IOriginatorAwareCommand<Type extends string> extends ICommand<Type> {
    originator: {
        accountId?: number;
        organizationUid?: string;
    };
}
export default ICommand;
