"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateDeviceFactory = exports.UpdateDeviceSchema = exports.UpdateDevice = exports.SyncDeviceOrganizationSubscriptions = exports.BanDevice = exports.ApproveDevice = exports.ChangeDeviceSubscription = exports.UpdateDeviceInfoFactory = exports.UpdateDeviceInfoSchema = exports.UpdateDeviceInfo = exports.UpdateDeviceOrganization = exports.DeviceIsAlreadyCreatedError = exports.CreateDeviceFactory = exports.CreateDeviceSchema = exports.CreateDevice = exports.UpdateDeviceName = exports.StartEditDeviceName = exports.MarkSetDevicePropertyDoneSchema = exports.SetDevicePropertySchema = exports.DeviceIdentityHashSchema = exports.DeviceUidSchema = void 0;
const zod_1 = require("zod");
const ICommand_1 = require("../ICommand");
const generators_1 = require("../generators");
const commandFactory_1 = require("../commandFactory");
const ApplicationType_1 = require("@signageos/common-types/dist/Application/ApplicationType");
const checksum_1 = require("@signageos/lib/dist/Hash/checksum");
const uid_1 = require("@signageos/common-types/dist/Entity/uid");
// returns 53chars device identity hash based on device uid
const deviceIdentityHash = (payload) => {
    const timestamp = (0, generators_1.now)().getTime().toString();
    const salt = '91d1520213acb1eee6b6805b8c9e564332815001675a5a3a32.';
    const identityHash = (0, checksum_1.checksumString)(timestamp, 20) + (0, checksum_1.checksumString)(salt + payload.uid, 33);
    return identityHash;
};
exports.DeviceUidSchema = zod_1.z.string().min(8).max(128);
exports.DeviceIdentityHashSchema = zod_1.z
    .string()
    .min(51)
    .max(53)
    .regex(new RegExp(`^[${uid_1.UID_CHARACTERS}]+$`), {
    message: `The UID is not a valid with 51 - 53 characters containing only the characters "${uid_1.UID_CHARACTERS}"`,
});
exports.SetDevicePropertySchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    deviceIdentityHash: exports.DeviceIdentityHashSchema,
});
exports.MarkSetDevicePropertyDoneSchema = ICommand_1.BaseCommandSchema.extend({
    uid: zod_1.z.string(),
}).strict();
exports.StartEditDeviceName = 'Device.StartEditDeviceName';
exports.UpdateDeviceName = 'Device.UpdateDeviceName';
exports.CreateDevice = 'Device.CreateDevice';
exports.CreateDeviceSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.CreateDevice),
    uid: exports.DeviceUidSchema,
    applicationType: ApplicationType_1.ApplicationTypeSchema,
    identityHash: zod_1.z.string().optional(),
    originator: ICommand_1.OriginatorSchema.optional(),
});
exports.CreateDeviceFactory = (0, commandFactory_1.createCommandFactory)(exports.CreateDeviceSchema, {
    identityHash: deviceIdentityHash,
});
class DeviceIsAlreadyCreatedError {
    constructor(duid) {
        this.duid = duid;
        this.type = DeviceIsAlreadyCreatedError.type;
        // only properties declared
    }
}
exports.DeviceIsAlreadyCreatedError = DeviceIsAlreadyCreatedError;
DeviceIsAlreadyCreatedError.type = 'Device.DeviceIsAlreadyCreatedError';
exports.UpdateDeviceOrganization = 'Device.UpdateDeviceOrganization';
// Used for backward compatibility where some devices are sending null instead of undefined
const convertNullToUndefined = (value) => value === null ? undefined : typeof value === 'object' ? value.value : value;
const deviceInfoValueSchema = zod_1.z
    .string()
    .nullable()
    .optional()
    // backward compatibility where some devices are sending object with value instead of string (Lenovo)
    .or(zod_1.z.object({ value: zod_1.z.string().optional() }))
    .transform(convertNullToUndefined);
exports.UpdateDeviceInfo = 'Device.UpdateDeviceInfo';
exports.UpdateDeviceInfoSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.UpdateDeviceInfo),
    deviceUid: exports.DeviceUidSchema,
    model: deviceInfoValueSchema,
    serialNumber: deviceInfoValueSchema,
    brand: deviceInfoValueSchema,
    osVersion: deviceInfoValueSchema,
});
exports.UpdateDeviceInfoFactory = (0, commandFactory_1.createCommandFactory)(exports.UpdateDeviceInfoSchema);
exports.ChangeDeviceSubscription = 'Device.ChangeDeviceSubscriptionType';
exports.ApproveDevice = 'Device.ApproveDevice';
exports.BanDevice = 'Device.BanDevice';
exports.SyncDeviceOrganizationSubscriptions = 'Device.SyncDeviceOrganizationSubscriptions';
exports.UpdateDevice = 'Device.UpdateDevice';
exports.UpdateDeviceSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.UpdateDevice),
    /**
     * identification of the device
     */
    deviceIdentityHash: exports.DeviceIdentityHashSchema,
    /**
     * Fields to update
     * Add more fields as needed
     */
    sonyCloudDeviceId: zod_1.z.string().optional().nullable(),
});
exports.UpdateDeviceFactory = (0, commandFactory_1.createCommandFactory)(exports.UpdateDeviceSchema);
//# sourceMappingURL=deviceCommands.js.map