import { z } from 'zod';
import { SubscriptionType } from '@signageos/common-types/dist/Subscription/subscription';
export declare const DeviceVerificationHashSchema: z.ZodEffects<z.ZodString, string, string>;
export type DeviceVerificationHash = z.infer<typeof DeviceVerificationHashSchema>;
export declare const PairDeviceVerification = "Device.Verification.PairDevice";
export declare const PairDeviceVerificationSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.Verification.PairDevice">;
    verificationHash: z.ZodEffects<z.ZodString, string, string>;
    subscriptionType: z.ZodNativeEnum<typeof SubscriptionType>;
    originator: z.ZodOptional<z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>>;
}, "strict", z.ZodTypeAny, {
    type: "Device.Verification.PairDevice";
    subscriptionType: SubscriptionType;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}, {
    type: "Device.Verification.PairDevice";
    subscriptionType: SubscriptionType;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}>;
export type PairDeviceVerification = z.infer<typeof PairDeviceVerificationSchema>;
export declare const PairDeviceVerificationFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
} & {
    subscriptionType: SubscriptionType;
    verificationHash: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Verification.PairDevice";
    subscriptionType: SubscriptionType;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.Verification.PairDevice">;
    verificationHash: z.ZodEffects<z.ZodString, string, string>;
    subscriptionType: z.ZodNativeEnum<typeof SubscriptionType>;
    originator: z.ZodOptional<z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>>;
}, "strict", z.ZodTypeAny, {
    type: "Device.Verification.PairDevice";
    subscriptionType: SubscriptionType;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}, {
    type: "Device.Verification.PairDevice";
    subscriptionType: SubscriptionType;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}>>;
/**
 * @deprecated Use PairDeviceVerification instead.
 */
export declare const PairDevice = "Device.Verification.PairDevice";
/**
 * @deprecated Use PairDeviceVerification instead.
 */
export type PairDevice = PairDeviceVerification;
export declare const HandleDeviceVerificationHashCreated = "Device.Verification.HandleVerificationHashCreated";
export declare const HandleDeviceVerificationHashCreatedSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.Verification.HandleVerificationHashCreated">;
    deviceUid: z.ZodString;
    verificationHash: z.ZodEffects<z.ZodString, string, string>;
    originator: z.ZodOptional<z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>>;
}, "strict", z.ZodTypeAny, {
    type: "Device.Verification.HandleVerificationHashCreated";
    deviceUid: string;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}, {
    type: "Device.Verification.HandleVerificationHashCreated";
    deviceUid: string;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}>;
export type HandleDeviceVerificationHashCreated = z.infer<typeof HandleDeviceVerificationHashCreatedSchema>;
export declare const HandleDeviceVerificationHashCreatedFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
} & {
    deviceUid: string;
    verificationHash: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Verification.HandleVerificationHashCreated";
    deviceUid: string;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.Verification.HandleVerificationHashCreated">;
    deviceUid: z.ZodString;
    verificationHash: z.ZodEffects<z.ZodString, string, string>;
    originator: z.ZodOptional<z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>>;
}, "strict", z.ZodTypeAny, {
    type: "Device.Verification.HandleVerificationHashCreated";
    deviceUid: string;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}, {
    type: "Device.Verification.HandleVerificationHashCreated";
    deviceUid: string;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}>>;
/**
 * @deprecated Use HandleDeviceVerificationHashCreated instead.
 */
export declare const HandleDeviceHashCreated = "Device.Verification.HandleVerificationHashCreated";
/**
 * @deprecated Use HandleDeviceVerificationHashCreated instead.
 */
export type HandleDeviceHashCreated = HandleDeviceVerificationHashCreated;
export declare const PairDeviceVerificationWithOrganization = "Device.PairDeviceWithOrganization";
/**
 * @property policyWithPriority The specific device policy can be optionally set to the device during verification.
 */
export declare const PairDeviceVerificationWithOrganizationSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.PairDeviceWithOrganization">;
    verificationHash: z.ZodEffects<z.ZodString, string, string>;
    organizationUid: z.ZodString;
    subscriptionType: z.ZodNativeEnum<typeof SubscriptionType>;
    deviceName: z.ZodOptional<z.ZodString>;
    policyWithPriority: z.ZodOptional<z.ZodObject<{
        policyUid: z.ZodString;
        priority: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        priority: number;
        policyUid: string;
    }, {
        priority: number;
        policyUid: string;
    }>>;
    originator: z.ZodOptional<z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>>;
}, "strict", z.ZodTypeAny, {
    type: "Device.PairDeviceWithOrganization";
    organizationUid: string;
    subscriptionType: SubscriptionType;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    deviceName?: string | undefined;
    policyWithPriority?: {
        priority: number;
        policyUid: string;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}, {
    type: "Device.PairDeviceWithOrganization";
    organizationUid: string;
    subscriptionType: SubscriptionType;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    deviceName?: string | undefined;
    policyWithPriority?: {
        priority: number;
        policyUid: string;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}>;
export type PairDeviceVerificationWithOrganization = z.infer<typeof PairDeviceVerificationWithOrganizationSchema>;
export declare const PairDeviceVerificationWithOrganizationFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
    deviceName?: string | undefined;
    policyWithPriority?: {
        priority: number;
        policyUid: string;
    } | undefined;
} & {
    organizationUid: string;
    subscriptionType: SubscriptionType;
    verificationHash: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.PairDeviceWithOrganization";
    organizationUid: string;
    subscriptionType: SubscriptionType;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    deviceName?: string | undefined;
    policyWithPriority?: {
        priority: number;
        policyUid: string;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.PairDeviceWithOrganization">;
    verificationHash: z.ZodEffects<z.ZodString, string, string>;
    organizationUid: z.ZodString;
    subscriptionType: z.ZodNativeEnum<typeof SubscriptionType>;
    deviceName: z.ZodOptional<z.ZodString>;
    policyWithPriority: z.ZodOptional<z.ZodObject<{
        policyUid: z.ZodString;
        priority: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        priority: number;
        policyUid: string;
    }, {
        priority: number;
        policyUid: string;
    }>>;
    originator: z.ZodOptional<z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>>;
}, "strict", z.ZodTypeAny, {
    type: "Device.PairDeviceWithOrganization";
    organizationUid: string;
    subscriptionType: SubscriptionType;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    deviceName?: string | undefined;
    policyWithPriority?: {
        priority: number;
        policyUid: string;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}, {
    type: "Device.PairDeviceWithOrganization";
    organizationUid: string;
    subscriptionType: SubscriptionType;
    verificationHash: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    deviceName?: string | undefined;
    policyWithPriority?: {
        priority: number;
        policyUid: string;
    } | undefined;
    originator?: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    } | undefined;
}>>;
/**
 * @deprecated Use PairDeviceVerificationWithOrganization instead.
 */
export declare const PairDeviceWithOrganization = "Device.PairDeviceWithOrganization";
/**
 * @deprecated Use PairDeviceVerificationWithOrganization instead.
 */
export type PairDeviceWithOrganization = PairDeviceVerificationWithOrganization;
