import ICommand, { IOriginatorAwareCommand } from '../../ICommand';
export declare const StartAppletTestSuite = "Device.Test.StartAppletTestSuite";
export interface StartAppletTestSuite extends IOriginatorAwareCommand<typeof StartAppletTestSuite> {
    deviceIdentityHash: string;
    appletUid: string;
    appletVersion: string;
    tests: string[];
}
export declare const MarkStartAppletTestSuiteFailed = "Device.Test.MarkStartAppletTestSuiteFailed";
export interface MarkStartAppletTestSuiteFailed extends ICommand<typeof MarkStartAppletTestSuiteFailed> {
    deviceIdentityHash: string;
    appletUid: string;
    appletVersion: string;
    uid: string;
}
export declare const MarkAppletTestSuiteCanceled = "Device.Test.MarkAppletTestSuiteCanceled";
export interface MarkAppletTestSuiteCanceled extends IOriginatorAwareCommand<typeof MarkAppletTestSuiteCanceled> {
    deviceIdentityHash: string;
    appletUid: string;
    appletVersion: string;
    uid: string;
}
export type ITestResult = {
    title: string;
    err?: any;
}[];
export declare const MarkAppletTestSucceeded = "Device.Test.MarkAppletTestSucceeded";
export interface MarkAppletTestSucceeded extends ICommand<typeof MarkAppletTestSucceeded> {
    deviceIdentityHash: string;
    appletUid: string;
    appletVersion: string;
    uid: string;
    identifier: string;
    report: ITestResult;
}
export declare const MarkAppletTestFailed = "Device.Test.MarkAppletTestFailed";
export interface MarkAppletTestFailed extends ICommand<typeof MarkAppletTestFailed> {
    deviceIdentityHash: string;
    appletUid: string;
    appletVersion: string;
    uid: string;
    identifier: string;
    report?: ITestResult;
    error?: string;
}
