"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MarkSetPeerRecoveryFailedFactory = exports.MarkSetPeerRecoveryFailedSchema = exports.MarkSetPeerRecoveryFailed = exports.MarkSetPeerRecoverySucceededFactory = exports.MarkSetPeerRecoverySucceededSchema = exports.MarkSetPeerRecoverySucceeded = exports.SetDisablePeerRecoveryFactory = exports.SetEnablePeerRecoveryFactory = exports.SetPeerRecoveryFactory = exports.SetPeerRecoverySchema = exports.SetDisablePeerRecoverySchema = exports.SetEnablePeerRecoverySchema = exports.SetPeerRecovery = void 0;
const zod_1 = require("zod");
const commandFactory_1 = require("../../commandFactory");
const deviceCommands_1 = require("../deviceCommands");
exports.SetPeerRecovery = 'Device.PeerRecovery.SetPeerRecovery';
exports.SetEnablePeerRecoverySchema = deviceCommands_1.SetDevicePropertySchema.extend({
    type: zod_1.z.literal(exports.SetPeerRecovery),
    enabled: zod_1.z.literal(true),
    /**
     * This URL address has to be set in URL launcher on device that is recovered.
     */
    urlLauncherAddress: zod_1.z.string().url(),
}).strict();
exports.SetDisablePeerRecoverySchema = deviceCommands_1.SetDevicePropertySchema.extend({
    type: zod_1.z.literal(exports.SetPeerRecovery),
    enabled: zod_1.z.literal(false),
    /**
     * It defines period until automatic enabling peer recovery process in milliseconds.
     */
    autoEnableTimeoutMs: zod_1.z.number().positive(),
}).strict();
exports.SetPeerRecoverySchema = zod_1.z.discriminatedUnion('enabled', [exports.SetEnablePeerRecoverySchema, exports.SetDisablePeerRecoverySchema]);
exports.SetPeerRecoveryFactory = (0, commandFactory_1.createCommandFactory)(exports.SetPeerRecoverySchema);
exports.SetEnablePeerRecoveryFactory = (0, commandFactory_1.createCommandFactory)(exports.SetEnablePeerRecoverySchema, undefined, { noRegisterCommandSchema: true });
exports.SetDisablePeerRecoveryFactory = (0, commandFactory_1.createCommandFactory)(exports.SetDisablePeerRecoverySchema, undefined, {
    noRegisterCommandSchema: true,
});
exports.MarkSetPeerRecoverySucceeded = 'Device.PeerRecovery.MarkSetPeerRecoverySucceeded';
exports.MarkSetPeerRecoverySucceededSchema = deviceCommands_1.MarkSetDevicePropertyDoneSchema.extend({
    type: zod_1.z.literal(exports.MarkSetPeerRecoverySucceeded),
}).strict();
exports.MarkSetPeerRecoverySucceededFactory = (0, commandFactory_1.createCommandFactory)(exports.MarkSetPeerRecoverySucceededSchema);
exports.MarkSetPeerRecoveryFailed = 'Device.PeerRecovery.MarkSetPeerRecoveryFailed';
exports.MarkSetPeerRecoveryFailedSchema = deviceCommands_1.MarkSetDevicePropertyDoneSchema.extend({
    type: zod_1.z.literal(exports.MarkSetPeerRecoveryFailed),
}).strict();
exports.MarkSetPeerRecoveryFailedFactory = (0, commandFactory_1.createCommandFactory)(exports.MarkSetPeerRecoveryFailedSchema);
//# sourceMappingURL=devicePeerRecoveryCommands.js.map