import { z } from 'zod';
import { AndroidInstalledSpecs } from '@signageos/common-types/dist/Package/Android/specs';
export declare const InstallDevicePackage = "Device.Package.InstallDevicePackage";
export declare const InstallDevicePackageSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.Package.InstallDevicePackage">;
    packageVersionUid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.InstallDevicePackage";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    packageVersionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.InstallDevicePackage";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    packageVersionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type InstallDevicePackage = z.infer<typeof InstallDevicePackageSchema>;
export declare const InstallDevicePackageFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    packageVersionUid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Package.InstallDevicePackage";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    packageVersionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.Package.InstallDevicePackage">;
    packageVersionUid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.InstallDevicePackage";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    packageVersionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.InstallDevicePackage";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    packageVersionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const MarkDevicePackageInstallationSucceeded = "Device.Package.MarkDevicePackageInstallationSucceeded";
export declare const MarkDevicePackageInstallationSucceededSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.Package.MarkDevicePackageInstallationSucceeded">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.MarkDevicePackageInstallationSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.MarkDevicePackageInstallationSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type MarkDevicePackageInstallationSucceeded = z.infer<typeof MarkDevicePackageInstallationSucceededSchema>;
export declare const MarkDevicePackageInstallationSucceededFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Package.MarkDevicePackageInstallationSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.Package.MarkDevicePackageInstallationSucceeded">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.MarkDevicePackageInstallationSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.MarkDevicePackageInstallationSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const MarkDevicePackageInstallationFailed = "Device.Package.MarkDevicePackageInstallationFailed";
export declare const MarkDevicePackageInstallationFailedSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.Package.MarkDevicePackageInstallationFailed">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.MarkDevicePackageInstallationFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.MarkDevicePackageInstallationFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type MarkDevicePackageInstallationFailed = z.infer<typeof MarkDevicePackageInstallationFailedSchema>;
export declare const MarkDevicePackageInstallationFailedFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Package.MarkDevicePackageInstallationFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.Package.MarkDevicePackageInstallationFailed">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.MarkDevicePackageInstallationFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.MarkDevicePackageInstallationFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const InstallDevicePackageFromUri = "Device.Package.InstallDevicePackageFromUri";
export declare const AndroidInstallDevicePackageFromUriSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    applicationType: z.ZodLiteral<"android">;
    deviceIdentityHash: z.ZodString;
    specs: z.ZodOptional<z.ZodObject<{
        packageName: z.ZodString;
        apkSha256: z.ZodOptional<z.ZodString>;
        signatureSha256: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    }, {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    }>>;
    packageUri: z.ZodString;
    type: z.ZodLiteral<"Device.Package.InstallDevicePackageFromUri">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.InstallDevicePackageFromUri";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "android";
    deviceIdentityHash: string;
    packageUri: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    specs?: {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    } | undefined;
}, {
    type: "Device.Package.InstallDevicePackageFromUri";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "android";
    deviceIdentityHash: string;
    packageUri: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    specs?: {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    } | undefined;
}>;
export declare const TizenInstallDevicePackageFromUriSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    applicationType: z.ZodLiteral<"tizen">;
    deviceIdentityHash: z.ZodString;
    specs: z.ZodOptional<z.ZodNever>;
    packageUri: z.ZodString;
    type: z.ZodLiteral<"Device.Package.InstallDevicePackageFromUri">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.InstallDevicePackageFromUri";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "tizen";
    deviceIdentityHash: string;
    packageUri: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    specs?: undefined;
}, {
    type: "Device.Package.InstallDevicePackageFromUri";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "tizen";
    deviceIdentityHash: string;
    packageUri: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    specs?: undefined;
}>;
export declare const InstallDevicePackageFromUriSchema: z.ZodDiscriminatedUnion<"applicationType", [z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    applicationType: z.ZodLiteral<"android">;
    deviceIdentityHash: z.ZodString;
    specs: z.ZodOptional<z.ZodObject<{
        packageName: z.ZodString;
        apkSha256: z.ZodOptional<z.ZodString>;
        signatureSha256: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    }, {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    }>>;
    packageUri: z.ZodString;
    type: z.ZodLiteral<"Device.Package.InstallDevicePackageFromUri">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.InstallDevicePackageFromUri";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "android";
    deviceIdentityHash: string;
    packageUri: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    specs?: {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    } | undefined;
}, {
    type: "Device.Package.InstallDevicePackageFromUri";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "android";
    deviceIdentityHash: string;
    packageUri: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    specs?: {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    } | undefined;
}>, z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    applicationType: z.ZodLiteral<"tizen">;
    deviceIdentityHash: z.ZodString;
    specs: z.ZodOptional<z.ZodNever>;
    packageUri: z.ZodString;
    type: z.ZodLiteral<"Device.Package.InstallDevicePackageFromUri">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.InstallDevicePackageFromUri";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "tizen";
    deviceIdentityHash: string;
    packageUri: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    specs?: undefined;
}, {
    type: "Device.Package.InstallDevicePackageFromUri";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "tizen";
    deviceIdentityHash: string;
    packageUri: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    specs?: undefined;
}>]>;
export type InstallDevicePackageFromUri = z.infer<typeof InstallDevicePackageFromUriSchema>;
export declare const InstallDevicePackageFromUriFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    specs?: {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "tizen" | "android";
    deviceIdentityHash: string;
    packageUri: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Package.InstallDevicePackageFromUri";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "android";
    deviceIdentityHash: string;
    packageUri: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    specs?: {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    } | undefined;
} | {
    type: "Device.Package.InstallDevicePackageFromUri";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "tizen";
    deviceIdentityHash: string;
    packageUri: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    specs?: undefined;
}, {}, Function>>) => z.TypeOf<z.ZodDiscriminatedUnion<"applicationType", [z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    applicationType: z.ZodLiteral<"android">;
    deviceIdentityHash: z.ZodString;
    specs: z.ZodOptional<z.ZodObject<{
        packageName: z.ZodString;
        apkSha256: z.ZodOptional<z.ZodString>;
        signatureSha256: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    }, {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    }>>;
    packageUri: z.ZodString;
    type: z.ZodLiteral<"Device.Package.InstallDevicePackageFromUri">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.InstallDevicePackageFromUri";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "android";
    deviceIdentityHash: string;
    packageUri: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    specs?: {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    } | undefined;
}, {
    type: "Device.Package.InstallDevicePackageFromUri";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "android";
    deviceIdentityHash: string;
    packageUri: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    specs?: {
        packageName: string;
        apkSha256?: string | undefined;
        signatureSha256?: string | undefined;
    } | undefined;
}>, z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    applicationType: z.ZodLiteral<"tizen">;
    deviceIdentityHash: z.ZodString;
    specs: z.ZodOptional<z.ZodNever>;
    packageUri: z.ZodString;
    type: z.ZodLiteral<"Device.Package.InstallDevicePackageFromUri">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.InstallDevicePackageFromUri";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "tizen";
    deviceIdentityHash: string;
    packageUri: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    specs?: undefined;
}, {
    type: "Device.Package.InstallDevicePackageFromUri";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "tizen";
    deviceIdentityHash: string;
    packageUri: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    specs?: undefined;
}>]>>;
export declare const MarkDevicePackageInstallationFromUriSucceeded = "Device.Package.MarkDevicePackageInstallationFromUriSucceeded";
export declare const MarkDevicePackageInstallationFromUriSucceededSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.Package.MarkDevicePackageInstallationFromUriSucceeded">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.MarkDevicePackageInstallationFromUriSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.MarkDevicePackageInstallationFromUriSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type MarkDevicePackageInstallationFromUriSucceeded = z.infer<typeof MarkDevicePackageInstallationFromUriSucceededSchema>;
export declare const MarkDevicePackageInstallationFromUriSucceededFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Package.MarkDevicePackageInstallationFromUriSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.Package.MarkDevicePackageInstallationFromUriSucceeded">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.MarkDevicePackageInstallationFromUriSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.MarkDevicePackageInstallationFromUriSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const MarkDevicePackageInstallationFromUriFailed = "Device.Package.MarkDevicePackageInstallationFromUriFailed";
export declare const MarkDevicePackageInstallationFromUriFailedSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.Package.MarkDevicePackageInstallationFromUriFailed">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.MarkDevicePackageInstallationFromUriFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.MarkDevicePackageInstallationFromUriFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type MarkDevicePackageInstallationFromUriFailed = z.infer<typeof MarkDevicePackageInstallationFromUriFailedSchema>;
export declare const MarkDevicePackageInstallationFromUriFailedFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Package.MarkDevicePackageInstallationFromUriFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.Package.MarkDevicePackageInstallationFromUriFailed">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.MarkDevicePackageInstallationFromUriFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.MarkDevicePackageInstallationFromUriFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const UninstallDevicePackage = "Device.Package.UninstallDevicePackage";
export declare const UninstallDevicePackageSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.Package.UninstallDevicePackage">;
    packageName: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.UninstallDevicePackage";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    packageName: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.UninstallDevicePackage";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    packageName: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type UninstallDevicePackage = z.infer<typeof UninstallDevicePackageSchema>;
export declare const UninstallDevicePackageFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    packageName: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Package.UninstallDevicePackage";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    packageName: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.Package.UninstallDevicePackage">;
    packageName: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.UninstallDevicePackage";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    packageName: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.UninstallDevicePackage";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    packageName: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const MarkDevicePackageUninstallationSucceeded = "Device.Package.MarkDevicePackageUninstallationSucceeded";
export declare const MarkDevicePackageUninstallationSucceededSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.Package.MarkDevicePackageUninstallationSucceeded">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.MarkDevicePackageUninstallationSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.MarkDevicePackageUninstallationSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type MarkDevicePackageUninstallationSucceeded = z.infer<typeof MarkDevicePackageUninstallationSucceededSchema>;
export declare const MarkDevicePackageUninstallationSucceededFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Package.MarkDevicePackageUninstallationSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.Package.MarkDevicePackageUninstallationSucceeded">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.MarkDevicePackageUninstallationSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.MarkDevicePackageUninstallationSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const MarkDevicePackageUninstallationFailed = "Device.Package.MarkDevicePackageUninstallationFailed";
export declare const MarkDevicePackageUninstallationFailedSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.Package.MarkDevicePackageUninstallationFailed">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.MarkDevicePackageUninstallationFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.MarkDevicePackageUninstallationFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type MarkDevicePackageUninstallationFailed = z.infer<typeof MarkDevicePackageUninstallationFailedSchema>;
export declare const MarkDevicePackageUninstallationFailedFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Package.MarkDevicePackageUninstallationFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.Package.MarkDevicePackageUninstallationFailed">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.MarkDevicePackageUninstallationFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.MarkDevicePackageUninstallationFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const StartDevicePackage = "Device.Package.StartDevicePackage";
export declare const StartDevicePackageSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.Package.StartDevicePackage">;
    packageName: z.ZodString;
    applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.StartDevicePackage";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos";
    deviceIdentityHash: string;
    packageName: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.StartDevicePackage";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos";
    deviceIdentityHash: string;
    packageName: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type StartDevicePackage = z.infer<typeof StartDevicePackageSchema>;
export declare const StartDevicePackageFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos";
    deviceIdentityHash: string;
    packageName: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Package.StartDevicePackage";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos";
    deviceIdentityHash: string;
    packageName: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.Package.StartDevicePackage">;
    packageName: z.ZodString;
    applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.StartDevicePackage";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos";
    deviceIdentityHash: string;
    packageName: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.StartDevicePackage";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    applicationType: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos";
    deviceIdentityHash: string;
    packageName: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const MarkDevicePackageStartSucceeded = "Device.Package.MarkDevicePackageStartSucceeded";
export declare const MarkDevicePackageStartSucceededSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.Package.MarkDevicePackageStartSucceeded">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.MarkDevicePackageStartSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.MarkDevicePackageStartSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type MarkDevicePackageStartSucceeded = z.infer<typeof MarkDevicePackageStartSucceededSchema>;
export declare const MarkDevicePackageStartSucceededFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Package.MarkDevicePackageStartSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.Package.MarkDevicePackageStartSucceeded">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.MarkDevicePackageStartSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.MarkDevicePackageStartSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const MarkDevicePackageStartFailed = "Device.Package.MarkDevicePackageStartFailed";
export declare const MarkDevicePackageStartFailedSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.Package.MarkDevicePackageStartFailed">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.MarkDevicePackageStartFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.MarkDevicePackageStartFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type MarkDevicePackageStartFailed = z.infer<typeof MarkDevicePackageStartFailedSchema>;
export declare const MarkDevicePackageStartFailedFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.Package.MarkDevicePackageStartFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.Package.MarkDevicePackageStartFailed">;
}, "strict", z.ZodTypeAny, {
    type: "Device.Package.MarkDevicePackageStartFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.Package.MarkDevicePackageStartFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
/** @deprecated Use {@link AndroidInstalledSpecs} instead */
export type IAndroidSpecs = AndroidInstalledSpecs;
