"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateInputSourceFactory = exports.UpdateInputSourceSchema = exports.UpdateInputSource = exports.MarkSetInputSourceFailedFactory = exports.MarkSetInputSourceFailedSchema = exports.MarkSetInputSourceFailed = exports.MarkSetInputSourceSucceededFactory = exports.MarkSetInputSourceSucceededSchema = exports.MarkSetInputSourceSucceeded = exports.SetInputSourceFactory = exports.SetInputSourceSchema = exports.SetInputSource = exports.InputSource = void 0;
const commandFactory_1 = require("../../commandFactory");
const zod_1 = require("zod");
const schemas_1 = require("../../schemas");
const deviceCommands_1 = require("../deviceCommands");
const ICommand_1 = require("../../ICommand");
var InputSource;
(function (InputSource) {
    InputSource["URL_LAUNCHER"] = "urlLauncher";
    InputSource["HDMI1"] = "hdmi1";
    InputSource["HDMI2"] = "hdmi2";
    InputSource["HDMI3"] = "hdmi3";
    InputSource["HDMI4"] = "hdmi4";
})(InputSource || (exports.InputSource = InputSource = {}));
const InputSourceSchema = zod_1.z.nativeEnum(InputSource);
exports.SetInputSource = 'Device.InputSource.SetInputSource';
exports.SetInputSourceSchema = deviceCommands_1.SetDevicePropertySchema.extend({
    type: zod_1.z.literal(exports.SetInputSource),
    uid: schemas_1.UIDSchema.or(schemas_1.LegacyUIDSchema),
    inputSource: InputSourceSchema,
});
exports.SetInputSourceFactory = (0, commandFactory_1.createCommandFactory)(exports.SetInputSourceSchema);
exports.MarkSetInputSourceSucceeded = 'Device.InputSource.MarkSetInputSourceSucceeded';
exports.MarkSetInputSourceSucceededSchema = deviceCommands_1.MarkSetDevicePropertyDoneSchema.extend({
    type: zod_1.z.literal(exports.MarkSetInputSourceSucceeded),
});
exports.MarkSetInputSourceSucceededFactory = (0, commandFactory_1.createCommandFactory)(exports.MarkSetInputSourceSucceededSchema);
exports.MarkSetInputSourceFailed = 'Device.InputSource.MarkSetInputSourceFailed';
exports.MarkSetInputSourceFailedSchema = deviceCommands_1.MarkSetDevicePropertyDoneSchema.extend({
    type: zod_1.z.literal(exports.MarkSetInputSourceFailed),
});
exports.MarkSetInputSourceFailedFactory = (0, commandFactory_1.createCommandFactory)(exports.MarkSetInputSourceFailedSchema);
exports.UpdateInputSource = 'Device.InputSource.UpdateInputSource';
exports.UpdateInputSourceSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.UpdateInputSource),
    deviceUid: deviceCommands_1.DeviceUidSchema,
    /**
     * It may be arbitrary platform-dependent string but common values are listed in enumeration.
     */
    inputSource: InputSourceSchema,
}).strict();
exports.UpdateInputSourceFactory = (0, commandFactory_1.createCommandFactory)(exports.UpdateInputSourceSchema);
//# sourceMappingURL=deviceInputSourceCommands.js.map