import { z } from 'zod';
export declare enum InputSource {
    URL_LAUNCHER = "urlLauncher",
    HDMI1 = "hdmi1",
    HDMI2 = "hdmi2",
    HDMI3 = "hdmi3",
    HDMI4 = "hdmi4"
}
export declare const SetInputSource = "Device.InputSource.SetInputSource";
export declare const SetInputSourceSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.InputSource.SetInputSource">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    inputSource: z.ZodNativeEnum<typeof InputSource>;
}, "strict", z.ZodTypeAny, {
    type: "Device.InputSource.SetInputSource";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceIdentityHash: string;
    inputSource: InputSource;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.InputSource.SetInputSource";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceIdentityHash: string;
    inputSource: InputSource;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type SetInputSource = z.infer<typeof SetInputSourceSchema>;
export declare const SetInputSourceFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceIdentityHash: string;
    inputSource: InputSource;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.InputSource.SetInputSource";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceIdentityHash: string;
    inputSource: InputSource;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.InputSource.SetInputSource">;
    uid: z.ZodUnion<[z.ZodString, z.ZodString]>;
    inputSource: z.ZodNativeEnum<typeof InputSource>;
}, "strict", z.ZodTypeAny, {
    type: "Device.InputSource.SetInputSource";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceIdentityHash: string;
    inputSource: InputSource;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.InputSource.SetInputSource";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    deviceIdentityHash: string;
    inputSource: InputSource;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const MarkSetInputSourceSucceeded = "Device.InputSource.MarkSetInputSourceSucceeded";
export declare const MarkSetInputSourceSucceededSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.InputSource.MarkSetInputSourceSucceeded">;
}, "strict", z.ZodTypeAny, {
    type: "Device.InputSource.MarkSetInputSourceSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.InputSource.MarkSetInputSourceSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type MarkSetInputSourceSucceeded = z.infer<typeof MarkSetInputSourceSucceededSchema>;
export declare const MarkSetInputSourceSucceededFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.InputSource.MarkSetInputSourceSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.InputSource.MarkSetInputSourceSucceeded">;
}, "strict", z.ZodTypeAny, {
    type: "Device.InputSource.MarkSetInputSourceSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.InputSource.MarkSetInputSourceSucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const MarkSetInputSourceFailed = "Device.InputSource.MarkSetInputSourceFailed";
export declare const MarkSetInputSourceFailedSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.InputSource.MarkSetInputSourceFailed">;
}, "strict", z.ZodTypeAny, {
    type: "Device.InputSource.MarkSetInputSourceFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.InputSource.MarkSetInputSourceFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type MarkSetInputSourceFailed = z.infer<typeof MarkSetInputSourceFailedSchema>;
export declare const MarkSetInputSourceFailedFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.InputSource.MarkSetInputSourceFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.InputSource.MarkSetInputSourceFailed">;
}, "strict", z.ZodTypeAny, {
    type: "Device.InputSource.MarkSetInputSourceFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.InputSource.MarkSetInputSourceFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const UpdateInputSource = "Device.InputSource.UpdateInputSource";
export declare const UpdateInputSourceSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.InputSource.UpdateInputSource">;
    deviceUid: z.ZodString;
    inputSource: z.ZodNativeEnum<typeof InputSource>;
}, "strict", z.ZodTypeAny, {
    type: "Device.InputSource.UpdateInputSource";
    deviceUid: string;
    inputSource: InputSource;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.InputSource.UpdateInputSource";
    deviceUid: string;
    inputSource: InputSource;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type UpdateInputSource = z.infer<typeof UpdateInputSourceSchema>;
export declare const UpdateInputSourceFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    deviceUid: string;
    inputSource: InputSource;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.InputSource.UpdateInputSource";
    deviceUid: string;
    inputSource: InputSource;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Device.InputSource.UpdateInputSource">;
    deviceUid: z.ZodString;
    inputSource: z.ZodNativeEnum<typeof InputSource>;
}, "strict", z.ZodTypeAny, {
    type: "Device.InputSource.UpdateInputSource";
    deviceUid: string;
    inputSource: InputSource;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.InputSource.UpdateInputSource";
    deviceUid: string;
    inputSource: InputSource;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
