"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateDeviceConfigurationTelemetryCheckIntervalFactory = exports.UpdateDeviceConfigurationTelemetryCheckIntervalSchema = exports.UpdateDeviceConfigurationTelemetryCheckInterval = void 0;
const zod_1 = require("zod");
const deviceCommands_1 = require("../deviceCommands");
const TelemetryIntervals_1 = require("@signageos/common-types/dist/Device/MonitoringLog/TelemetryIntervals");
const commandFactory_1 = require("../../commandFactory");
exports.UpdateDeviceConfigurationTelemetryCheckInterval = 'Device.Configuration.UpdateDeviceConfigurationTelemetryCheckInterval';
exports.UpdateDeviceConfigurationTelemetryCheckIntervalSchema = deviceCommands_1.SetDevicePropertySchema.extend({
    type: zod_1.z.literal(exports.UpdateDeviceConfigurationTelemetryCheckInterval),
    telemetryCheckIntervals: zod_1.z.object({
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.SCREENSHOTS]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.TEMPERATURE]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.APPLICATION_VERSION]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.FRONT_DISPLAY_VERSION]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.BRIGHTNESS]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.DATETIME]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.DEBUG]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.FIRMWARE_VERSION]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.ORIENTATION]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.POWER_ACTIONS_SCHEDULE]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.PROPRIETARY_TIMERS]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.REMOTE_CONTROL]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.RESOLUTION]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.TIMERS]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.VOLUME]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.STORAGE]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.BATTERY]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.POLICY]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.PEER_RECOVERY]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.AUTO_RECOVERY]: zod_1.z.number().positive().optional(),
        [TelemetryIntervals_1.TelemetryConfigurationCheckInterval.DEFAULT]: zod_1.z.number().positive().optional(),
    }),
});
exports.UpdateDeviceConfigurationTelemetryCheckIntervalFactory = (0, commandFactory_1.createCommandFactory)(exports.UpdateDeviceConfigurationTelemetryCheckIntervalSchema);
//# sourceMappingURL=deviceConfigurationTelemetryCommands.js.map