import { z } from 'zod';
export declare const SetAutoRecovery = "Device.AutoRecovery.SetAutoRecovery";
export declare const SetEnableAutoRecoverySchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.AutoRecovery.SetAutoRecovery">;
    enabled: z.ZodLiteral<true>;
    healthcheckIntervalMs: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    healthcheckIntervalMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    healthcheckIntervalMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export declare const SetDisableAutoRecoverySchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.AutoRecovery.SetAutoRecovery">;
    enabled: z.ZodLiteral<false>;
    autoEnableTimeoutMs: z.ZodOptional<z.ZodNumber>;
}, "strict", z.ZodTypeAny, {
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    autoEnableTimeoutMs?: number | undefined;
}, {
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    autoEnableTimeoutMs?: number | undefined;
}>;
export declare const SetAutoRecoverySchema: z.ZodDiscriminatedUnion<"enabled", [z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.AutoRecovery.SetAutoRecovery">;
    enabled: z.ZodLiteral<true>;
    healthcheckIntervalMs: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    healthcheckIntervalMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    healthcheckIntervalMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>, z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.AutoRecovery.SetAutoRecovery">;
    enabled: z.ZodLiteral<false>;
    autoEnableTimeoutMs: z.ZodOptional<z.ZodNumber>;
}, "strict", z.ZodTypeAny, {
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    autoEnableTimeoutMs?: number | undefined;
}, {
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    autoEnableTimeoutMs?: number | undefined;
}>]>;
export type SetAutoRecovery = z.infer<typeof SetAutoRecoverySchema>;
export type SetEnableAutoRecovery = z.infer<typeof SetEnableAutoRecoverySchema>;
export type SetDisableAutoRecovery = z.infer<typeof SetDisableAutoRecoverySchema>;
export declare const SetAutoRecoveryFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: boolean;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    healthcheckIntervalMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} | {
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    autoEnableTimeoutMs?: number | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodDiscriminatedUnion<"enabled", [z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.AutoRecovery.SetAutoRecovery">;
    enabled: z.ZodLiteral<true>;
    healthcheckIntervalMs: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    healthcheckIntervalMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    healthcheckIntervalMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>, z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.AutoRecovery.SetAutoRecovery">;
    enabled: z.ZodLiteral<false>;
    autoEnableTimeoutMs: z.ZodOptional<z.ZodNumber>;
}, "strict", z.ZodTypeAny, {
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    autoEnableTimeoutMs?: number | undefined;
}, {
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    autoEnableTimeoutMs?: number | undefined;
}>]>>;
export declare const SetEnableAutoRecoveryFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    originator: import("../../types").ObjectRecursiveDifference<{
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.AutoRecovery.SetAutoRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: true;
        healthcheckIntervalMs: number;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }> | {
        accountId?: import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        }> | (number | undefined);
        organizationUid?: import("../../commandFactory").PropGenerator | (string | undefined) | import("../../commandFactory").PropGeneratorWithPayload<{
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        }>;
    } | undefined, Function>;
    deviceIdentityHash: string;
    enabled: true;
    healthcheckIntervalMs: number;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    healthcheckIntervalMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type?: import("../../commandFactory").PropGenerator | "Device.AutoRecovery.SetAutoRecovery" | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.AutoRecovery.SetAutoRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: true;
        healthcheckIntervalMs: number;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }> | undefined;
    originator?: import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.AutoRecovery.SetAutoRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: true;
        healthcheckIntervalMs: number;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }> | {
        accountId?: import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        }> | (number | undefined);
        organizationUid?: import("../../commandFactory").PropGenerator | (string | undefined) | import("../../commandFactory").PropGeneratorWithPayload<{
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        }>;
    } | undefined;
    deviceIdentityHash?: string | import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.AutoRecovery.SetAutoRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: true;
        healthcheckIntervalMs: number;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }> | undefined;
    enabled?: true | import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.AutoRecovery.SetAutoRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: true;
        healthcheckIntervalMs: number;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }> | undefined;
    healthcheckIntervalMs?: number | import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.AutoRecovery.SetAutoRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: true;
        healthcheckIntervalMs: number;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }> | undefined;
    context?: import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.AutoRecovery.SetAutoRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: true;
        healthcheckIntervalMs: number;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
    }> | ({
        whiteLabelSettingsUid?: import("../../commandFactory").PropGenerator | (string | undefined) | import("../../commandFactory").PropGeneratorWithPayload<{
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        }>;
        auth0Enabled?: import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        }> | (boolean | undefined);
    } | undefined);
}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.AutoRecovery.SetAutoRecovery">;
    enabled: z.ZodLiteral<true>;
    healthcheckIntervalMs: z.ZodNumber;
}, "strict", z.ZodTypeAny, {
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    healthcheckIntervalMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: true;
    healthcheckIntervalMs: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const SetDisableAutoRecoveryFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    autoEnableTimeoutMs?: number | undefined;
} & {
    originator: import("../../types").ObjectRecursiveDifference<{
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, import("../../commandFactory").PropGenerator | {
        accountId?: import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        }> | (number | undefined);
        organizationUid?: import("../../commandFactory").PropGenerator | (string | undefined) | import("../../commandFactory").PropGeneratorWithPayload<{
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        }>;
    } | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.AutoRecovery.SetAutoRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: false;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
        autoEnableTimeoutMs?: number | undefined;
    }> | undefined, Function>;
    deviceIdentityHash: string;
    enabled: false;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    autoEnableTimeoutMs?: number | undefined;
}, {
    type?: import("../../commandFactory").PropGenerator | "Device.AutoRecovery.SetAutoRecovery" | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.AutoRecovery.SetAutoRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: false;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
        autoEnableTimeoutMs?: number | undefined;
    }> | undefined;
    originator?: import("../../commandFactory").PropGenerator | {
        accountId?: import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        }> | (number | undefined);
        organizationUid?: import("../../commandFactory").PropGenerator | (string | undefined) | import("../../commandFactory").PropGeneratorWithPayload<{
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        }>;
    } | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.AutoRecovery.SetAutoRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: false;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
        autoEnableTimeoutMs?: number | undefined;
    }> | undefined;
    deviceIdentityHash?: string | import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.AutoRecovery.SetAutoRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: false;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
        autoEnableTimeoutMs?: number | undefined;
    }> | undefined;
    enabled?: false | import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.AutoRecovery.SetAutoRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: false;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
        autoEnableTimeoutMs?: number | undefined;
    }> | undefined;
    context?: import("../../commandFactory").PropGenerator | ({
        whiteLabelSettingsUid?: import("../../commandFactory").PropGenerator | (string | undefined) | import("../../commandFactory").PropGeneratorWithPayload<{
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        }>;
        auth0Enabled?: import("../../commandFactory").PropGenerator | import("../../commandFactory").PropGeneratorWithPayload<{
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        }> | (boolean | undefined);
    } | undefined) | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.AutoRecovery.SetAutoRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: false;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
        autoEnableTimeoutMs?: number | undefined;
    }>;
    autoEnableTimeoutMs?: import("../../commandFactory").PropGenerator | (number | undefined) | import("../../commandFactory").PropGeneratorWithPayload<{
        type: "Device.AutoRecovery.SetAutoRecovery";
        originator: {
            accountId?: number | undefined;
            organizationUid?: string | undefined;
        };
        deviceIdentityHash: string;
        enabled: false;
        context?: {
            whiteLabelSettingsUid?: string | undefined;
            auth0Enabled?: boolean | undefined;
        } | undefined;
        autoEnableTimeoutMs?: number | undefined;
    }>;
}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    deviceIdentityHash: z.ZodString;
    type: z.ZodLiteral<"Device.AutoRecovery.SetAutoRecovery">;
    enabled: z.ZodLiteral<false>;
    autoEnableTimeoutMs: z.ZodOptional<z.ZodNumber>;
}, "strict", z.ZodTypeAny, {
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    autoEnableTimeoutMs?: number | undefined;
}, {
    type: "Device.AutoRecovery.SetAutoRecovery";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    deviceIdentityHash: string;
    enabled: false;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    autoEnableTimeoutMs?: number | undefined;
}>>;
export declare const MarkSetAutoRecoverySucceeded = "Device.AutoRecovery.MarkAutoRecoverySucceeded";
export declare const MarkSetAutoRecoverySucceededSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.AutoRecovery.MarkAutoRecoverySucceeded">;
}, "strict", z.ZodTypeAny, {
    type: "Device.AutoRecovery.MarkAutoRecoverySucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.AutoRecovery.MarkAutoRecoverySucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type MarkSetAutoRecoverySucceeded = z.infer<typeof MarkSetAutoRecoverySucceededSchema>;
export declare const MarkSetAutoRecoverySucceededFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.AutoRecovery.MarkAutoRecoverySucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.AutoRecovery.MarkAutoRecoverySucceeded">;
}, "strict", z.ZodTypeAny, {
    type: "Device.AutoRecovery.MarkAutoRecoverySucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.AutoRecovery.MarkAutoRecoverySucceeded";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const MarkSetAutoRecoveryFailed = "Device.AutoRecovery.MarkAutoRecoveryFailed";
export declare const MarkSetAutoRecoveryFailedSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.AutoRecovery.MarkAutoRecoveryFailed">;
}, "strict", z.ZodTypeAny, {
    type: "Device.AutoRecovery.MarkAutoRecoveryFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.AutoRecovery.MarkAutoRecoveryFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type MarkSetAutoRecoveryFailed = z.infer<typeof MarkSetAutoRecoveryFailedSchema>;
export declare const MarkSetAutoRecoveryFailedFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    uid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Device.AutoRecovery.MarkAutoRecoveryFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    uid: z.ZodString;
    type: z.ZodLiteral<"Device.AutoRecovery.MarkAutoRecoveryFailed">;
}, "strict", z.ZodTypeAny, {
    type: "Device.AutoRecovery.MarkAutoRecoveryFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Device.AutoRecovery.MarkAutoRecoveryFailed";
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
