import { z } from 'zod';
/**
 * Adds context about Auth0
 *
 * We currently support signup/login via both Auth0 and our own custom system.
 * Box is responsible for selecting, which one to use.
 * Depending which one is selected, some commands will have different behavior.
 *
 * For example, if Box sends a command to invite a user and Auth0 is enabled, the email will be sent via Auth0.
 * If Auth0 is disabled, the email will be sent via our own internal service.
 */
declare const Auth0ContextSchema: z.ZodObject<{
    auth0Enabled: z.ZodOptional<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    auth0Enabled?: boolean | undefined;
}, {
    auth0Enabled?: boolean | undefined;
}>;
export type Auth0Context = z.infer<typeof Auth0ContextSchema>;
declare const ContextSchema: z.ZodObject<{
    whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
    auth0Enabled: z.ZodOptional<z.ZodBoolean>;
}, "strict", z.ZodTypeAny, {
    whiteLabelSettingsUid?: string | undefined;
    auth0Enabled?: boolean | undefined;
}, {
    whiteLabelSettingsUid?: string | undefined;
    auth0Enabled?: boolean | undefined;
}>;
export type Context = z.infer<typeof ContextSchema>;
/**
 * Adds context to a command
 *
 * Context is information about the environment where the command was produced.
 * It serves as metadata that can be reflected in the produced events.
 */
export declare const ContextAwareCommandSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
}, "strict", z.ZodTypeAny, {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type ContextAwareCommand = z.infer<typeof ContextAwareCommandSchema>;
export {};
