"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnassignWhiteLabelSettingsFromCompanyNetworkFactory = exports.UnassignWhiteLabelSettingsFromCompanyNetworkSchema = exports.UnassignWhiteLabelSettingsFromCompanyNetwork = exports.AssignWhiteLabelSettingsToCompanyNetworkFactory = exports.AssignWhiteLabelSettingsToCompanyNetworkSchema = exports.AssignWhiteLabelSettingsToCompanyNetwork = exports.UpdateCompanyNetworkFactory = exports.UpdateCompanyNetworkSchema = exports.UpdateCompanyNetwork = exports.CreateCompanyNetworkFactory = exports.CreateCompanyNetworkSchema = exports.CreateCompanyNetwork = exports.CompanyNetworkUIDSchema = exports.CompanyNetworkSchema = void 0;
const zod_1 = require("zod");
const deviceFilter_1 = require("@signageos/common-types/dist/Device/deviceFilter");
const subscription_1 = require("@signageos/common-types/dist/Subscription/subscription");
const WhiteLabelSettingsUIDSchema_1 = require("../WhiteLabelSettings/WhiteLabelSettingsUIDSchema");
const commandFactory_1 = require("../commandFactory");
const generators_1 = require("../generators");
const entityCommands_1 = require("../Entity/entityCommands");
const ICommand_1 = require("../ICommand");
/**
 * Hierarchy in entity relation CompanyNetwork -> Company -> Organization -> Device
 */
exports.CompanyNetworkSchema = entityCommands_1.EntitySchema.extend({
    /** Subscription type works as override for all organizations within the companies within the company network */
    subscriptionType: subscription_1.SubscriptionTypeSchema,
    whiteLabelSettingsUid: WhiteLabelSettingsUIDSchema_1.WhiteLabelSettingsUIDSchema.optional(),
    /** This filter should be applied as device filter for fetching devices by the company network */
    deviceFilter: deviceFilter_1.DeviceFilterSchema.pick({ brands: true, applicationTypes: true }).optional(),
    name: zod_1.z.string(),
});
exports.CompanyNetworkUIDSchema = exports.CompanyNetworkSchema.shape.uid;
exports.CreateCompanyNetwork = 'CompanyNetwork.CreateCompanyNetwork';
exports.CreateCompanyNetworkSchema = (0, entityCommands_1.createCreateEntityCommandSchema)(exports.CreateCompanyNetwork, exports.CompanyNetworkSchema);
exports.CreateCompanyNetworkFactory = (0, commandFactory_1.createCommandFactory)(exports.CreateCompanyNetworkSchema, { uid: generators_1.uid });
exports.UpdateCompanyNetwork = 'CompanyNetwork.UpdateCompanyNetwork';
exports.UpdateCompanyNetworkSchema = (0, entityCommands_1.createUpdateEntityCommandSchema)(exports.UpdateCompanyNetwork, exports.CompanyNetworkSchema);
exports.UpdateCompanyNetworkFactory = (0, commandFactory_1.createCommandFactory)(exports.UpdateCompanyNetworkSchema);
exports.AssignWhiteLabelSettingsToCompanyNetwork = 'WhiteLabelSettings.AssignToCompanyNetwork';
exports.AssignWhiteLabelSettingsToCompanyNetworkSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.AssignWhiteLabelSettingsToCompanyNetwork),
    companyNetworkUid: exports.CompanyNetworkUIDSchema,
    whiteLabelSettingsUid: WhiteLabelSettingsUIDSchema_1.WhiteLabelSettingsUIDSchema,
}).strict();
exports.AssignWhiteLabelSettingsToCompanyNetworkFactory = (0, commandFactory_1.createCommandFactory)(exports.AssignWhiteLabelSettingsToCompanyNetworkSchema);
exports.UnassignWhiteLabelSettingsFromCompanyNetwork = 'WhiteLabelSettings.UnassignFromCompanyNetwork';
exports.UnassignWhiteLabelSettingsFromCompanyNetworkSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.UnassignWhiteLabelSettingsFromCompanyNetwork),
    companyNetworkUid: exports.CompanyNetworkUIDSchema,
    whiteLabelSettingsUid: WhiteLabelSettingsUIDSchema_1.WhiteLabelSettingsUIDSchema,
}).strict();
exports.UnassignWhiteLabelSettingsFromCompanyNetworkFactory = (0, commandFactory_1.createCommandFactory)(exports.UnassignWhiteLabelSettingsFromCompanyNetworkSchema);
//# sourceMappingURL=companyNetworkCommands.js.map