import { z } from 'zod';
/**
 * Hierarchy in entity relation CompanyNetwork -> Company -> Organization -> Device
 */
export declare const CompanyNetworkSchema: z.ZodObject<{
    uid: z.ZodString;
    subscriptionType: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Subscription/subscription").SubscriptionType>;
    whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
    deviceFilter: z.ZodOptional<z.ZodObject<Pick<{
        search: z.ZodOptional<z.ZodString>;
        organizationUid: z.ZodOptional<z.ZodString>;
        firmwareVersion: z.ZodOptional<z.ZodString>;
        applicationType: z.ZodOptional<z.ZodString>;
        identityHash: z.ZodOptional<z.ZodString>;
        identityHashes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        identityHashesExclude: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        uids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        uidsExclude: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        accountId: z.ZodOptional<z.ZodNumber>;
        applicationTypes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        applicationTypeNotEqual: z.ZodOptional<z.ZodString>;
        model: z.ZodOptional<z.ZodString>;
        brands: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        firmwareType: z.ZodOptional<z.ZodString>;
        serialNumber: z.ZodOptional<z.ZodString>;
        minStorageStatusPercentage: z.ZodOptional<z.ZodNumber>;
        maxStorageStatusPercentage: z.ZodOptional<z.ZodNumber>;
        bannedSince: z.ZodOptional<z.ZodDate>;
        policyUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        createdSince: z.ZodOptional<z.ZodDate>;
        createdUntil: z.ZodOptional<z.ZodDate>;
        filterModelName: z.ZodOptional<z.ZodString>;
        appletUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        osVersions: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        orFilter: z.ZodOptional<z.ZodObject<{
            tagUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            tagWithChildrenUidGroups: z.ZodOptional<z.ZodArray<z.ZodArray<z.ZodString, "many">, "many">>;
            locationUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strict", z.ZodTypeAny, {
            tagUids?: string[] | undefined;
            tagWithChildrenUidGroups?: string[][] | undefined;
            locationUids?: string[] | undefined;
        }, {
            tagUids?: string[] | undefined;
            tagWithChildrenUidGroups?: string[][] | undefined;
            locationUids?: string[] | undefined;
        }>>;
        hasPolicy: z.ZodOptional<z.ZodBoolean>;
        tagUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        tagWithChildrenUidGroups: z.ZodOptional<z.ZodArray<z.ZodArray<z.ZodString, "many">, "many">>;
        locationUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "applicationTypes" | "brands">, "strict", z.ZodTypeAny, {
        applicationTypes?: string[] | undefined;
        brands?: string[] | undefined;
    }, {
        applicationTypes?: string[] | undefined;
        brands?: string[] | undefined;
    }>>;
    name: z.ZodString;
}, "strict", z.ZodTypeAny, {
    name: string;
    uid: string;
    subscriptionType: import("@signageos/common-types/dist/Subscription/subscription").SubscriptionType;
    whiteLabelSettingsUid?: string | undefined;
    deviceFilter?: {
        applicationTypes?: string[] | undefined;
        brands?: string[] | undefined;
    } | undefined;
}, {
    name: string;
    uid: string;
    subscriptionType: import("@signageos/common-types/dist/Subscription/subscription").SubscriptionType;
    whiteLabelSettingsUid?: string | undefined;
    deviceFilter?: {
        applicationTypes?: string[] | undefined;
        brands?: string[] | undefined;
    } | undefined;
}>;
export declare const CompanyNetworkUIDSchema: z.ZodString;
export declare const CreateCompanyNetwork = "CompanyNetwork.CreateCompanyNetwork";
export declare const CreateCompanyNetworkSchema: import("../Entity/entityCommands").CreateEntityCommandSchema<"CompanyNetwork.CreateCompanyNetwork", {
    uid: z.ZodString;
    subscriptionType: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Subscription/subscription").SubscriptionType>;
    whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
    deviceFilter: z.ZodOptional<z.ZodObject<Pick<{
        search: z.ZodOptional<z.ZodString>;
        organizationUid: z.ZodOptional<z.ZodString>;
        firmwareVersion: z.ZodOptional<z.ZodString>;
        applicationType: z.ZodOptional<z.ZodString>;
        identityHash: z.ZodOptional<z.ZodString>;
        identityHashes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        identityHashesExclude: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        uids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        uidsExclude: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        accountId: z.ZodOptional<z.ZodNumber>;
        applicationTypes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        applicationTypeNotEqual: z.ZodOptional<z.ZodString>;
        model: z.ZodOptional<z.ZodString>;
        brands: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        firmwareType: z.ZodOptional<z.ZodString>;
        serialNumber: z.ZodOptional<z.ZodString>;
        minStorageStatusPercentage: z.ZodOptional<z.ZodNumber>;
        maxStorageStatusPercentage: z.ZodOptional<z.ZodNumber>;
        bannedSince: z.ZodOptional<z.ZodDate>;
        policyUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        createdSince: z.ZodOptional<z.ZodDate>;
        createdUntil: z.ZodOptional<z.ZodDate>;
        filterModelName: z.ZodOptional<z.ZodString>;
        appletUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        osVersions: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        orFilter: z.ZodOptional<z.ZodObject<{
            tagUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            tagWithChildrenUidGroups: z.ZodOptional<z.ZodArray<z.ZodArray<z.ZodString, "many">, "many">>;
            locationUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strict", z.ZodTypeAny, {
            tagUids?: string[] | undefined;
            tagWithChildrenUidGroups?: string[][] | undefined;
            locationUids?: string[] | undefined;
        }, {
            tagUids?: string[] | undefined;
            tagWithChildrenUidGroups?: string[][] | undefined;
            locationUids?: string[] | undefined;
        }>>;
        hasPolicy: z.ZodOptional<z.ZodBoolean>;
        tagUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        tagWithChildrenUidGroups: z.ZodOptional<z.ZodArray<z.ZodArray<z.ZodString, "many">, "many">>;
        locationUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "applicationTypes" | "brands">, "strict", z.ZodTypeAny, {
        applicationTypes?: string[] | undefined;
        brands?: string[] | undefined;
    }, {
        applicationTypes?: string[] | undefined;
        brands?: string[] | undefined;
    }>>;
    name: z.ZodString;
}>;
export type CreateCompanyNetwork = z.infer<typeof CreateCompanyNetworkSchema>;
export declare const CreateCompanyNetworkFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    whiteLabelSettingsUid?: string | undefined;
    deviceFilter?: {
        applicationTypes?: string[] | undefined;
        brands?: string[] | undefined;
    } | undefined;
} & {
    name: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    subscriptionType: import("@signageos/common-types/dist/Subscription/subscription").SubscriptionType;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    name: string;
    type: "CompanyNetwork.CreateCompanyNetwork";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    subscriptionType: import("@signageos/common-types/dist/Subscription/subscription").SubscriptionType;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    whiteLabelSettingsUid?: string | undefined;
    deviceFilter?: {
        applicationTypes?: string[] | undefined;
        brands?: string[] | undefined;
    } | undefined;
}, {
    uid: () => string;
}, Function>>) => z.TypeOf<import("../Entity/entityCommands").CreateEntityCommandSchema<"CompanyNetwork.CreateCompanyNetwork", {
    uid: z.ZodString;
    subscriptionType: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Subscription/subscription").SubscriptionType>;
    whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
    deviceFilter: z.ZodOptional<z.ZodObject<Pick<{
        search: z.ZodOptional<z.ZodString>;
        organizationUid: z.ZodOptional<z.ZodString>;
        firmwareVersion: z.ZodOptional<z.ZodString>;
        applicationType: z.ZodOptional<z.ZodString>;
        identityHash: z.ZodOptional<z.ZodString>;
        identityHashes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        identityHashesExclude: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        uids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        uidsExclude: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        accountId: z.ZodOptional<z.ZodNumber>;
        applicationTypes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        applicationTypeNotEqual: z.ZodOptional<z.ZodString>;
        model: z.ZodOptional<z.ZodString>;
        brands: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        firmwareType: z.ZodOptional<z.ZodString>;
        serialNumber: z.ZodOptional<z.ZodString>;
        minStorageStatusPercentage: z.ZodOptional<z.ZodNumber>;
        maxStorageStatusPercentage: z.ZodOptional<z.ZodNumber>;
        bannedSince: z.ZodOptional<z.ZodDate>;
        policyUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        createdSince: z.ZodOptional<z.ZodDate>;
        createdUntil: z.ZodOptional<z.ZodDate>;
        filterModelName: z.ZodOptional<z.ZodString>;
        appletUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        osVersions: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        orFilter: z.ZodOptional<z.ZodObject<{
            tagUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            tagWithChildrenUidGroups: z.ZodOptional<z.ZodArray<z.ZodArray<z.ZodString, "many">, "many">>;
            locationUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strict", z.ZodTypeAny, {
            tagUids?: string[] | undefined;
            tagWithChildrenUidGroups?: string[][] | undefined;
            locationUids?: string[] | undefined;
        }, {
            tagUids?: string[] | undefined;
            tagWithChildrenUidGroups?: string[][] | undefined;
            locationUids?: string[] | undefined;
        }>>;
        hasPolicy: z.ZodOptional<z.ZodBoolean>;
        tagUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        tagWithChildrenUidGroups: z.ZodOptional<z.ZodArray<z.ZodArray<z.ZodString, "many">, "many">>;
        locationUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "applicationTypes" | "brands">, "strict", z.ZodTypeAny, {
        applicationTypes?: string[] | undefined;
        brands?: string[] | undefined;
    }, {
        applicationTypes?: string[] | undefined;
        brands?: string[] | undefined;
    }>>;
    name: z.ZodString;
}>>;
export declare const UpdateCompanyNetwork = "CompanyNetwork.UpdateCompanyNetwork";
export declare const UpdateCompanyNetworkSchema: import("../Entity/entityCommands").UpdateEntityCommandSchema<"CompanyNetwork.UpdateCompanyNetwork", {
    uid: z.ZodString;
    subscriptionType: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Subscription/subscription").SubscriptionType>;
    whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
    deviceFilter: z.ZodOptional<z.ZodObject<Pick<{
        search: z.ZodOptional<z.ZodString>;
        organizationUid: z.ZodOptional<z.ZodString>;
        firmwareVersion: z.ZodOptional<z.ZodString>;
        applicationType: z.ZodOptional<z.ZodString>;
        identityHash: z.ZodOptional<z.ZodString>;
        identityHashes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        identityHashesExclude: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        uids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        uidsExclude: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        accountId: z.ZodOptional<z.ZodNumber>;
        applicationTypes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        applicationTypeNotEqual: z.ZodOptional<z.ZodString>;
        model: z.ZodOptional<z.ZodString>;
        brands: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        firmwareType: z.ZodOptional<z.ZodString>;
        serialNumber: z.ZodOptional<z.ZodString>;
        minStorageStatusPercentage: z.ZodOptional<z.ZodNumber>;
        maxStorageStatusPercentage: z.ZodOptional<z.ZodNumber>;
        bannedSince: z.ZodOptional<z.ZodDate>;
        policyUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        createdSince: z.ZodOptional<z.ZodDate>;
        createdUntil: z.ZodOptional<z.ZodDate>;
        filterModelName: z.ZodOptional<z.ZodString>;
        appletUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        osVersions: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        orFilter: z.ZodOptional<z.ZodObject<{
            tagUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            tagWithChildrenUidGroups: z.ZodOptional<z.ZodArray<z.ZodArray<z.ZodString, "many">, "many">>;
            locationUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strict", z.ZodTypeAny, {
            tagUids?: string[] | undefined;
            tagWithChildrenUidGroups?: string[][] | undefined;
            locationUids?: string[] | undefined;
        }, {
            tagUids?: string[] | undefined;
            tagWithChildrenUidGroups?: string[][] | undefined;
            locationUids?: string[] | undefined;
        }>>;
        hasPolicy: z.ZodOptional<z.ZodBoolean>;
        tagUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        tagWithChildrenUidGroups: z.ZodOptional<z.ZodArray<z.ZodArray<z.ZodString, "many">, "many">>;
        locationUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "applicationTypes" | "brands">, "strict", z.ZodTypeAny, {
        applicationTypes?: string[] | undefined;
        brands?: string[] | undefined;
    }, {
        applicationTypes?: string[] | undefined;
        brands?: string[] | undefined;
    }>>;
    name: z.ZodString;
}>;
export type UpdateCompanyNetwork = z.infer<typeof UpdateCompanyNetworkSchema>;
export declare const UpdateCompanyNetworkFactory: (data: {
    name?: string | undefined;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    whiteLabelSettingsUid?: string | null | undefined;
    subscriptionType?: import("@signageos/common-types/dist/Subscription/subscription").SubscriptionType | undefined;
    deviceFilter?: {
        applicationTypes?: string[] | undefined;
        brands?: string[] | undefined;
    } | null | undefined;
} & {
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "CompanyNetwork.UpdateCompanyNetwork";
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    uid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    subscriptionType?: import("@signageos/common-types/dist/Subscription/subscription").SubscriptionType | undefined;
    whiteLabelSettingsUid?: string | null | undefined;
    deviceFilter?: {
        applicationTypes?: string[] | undefined;
        brands?: string[] | undefined;
    } | null | undefined;
    name?: string | undefined;
}, {}, Function>>) => z.TypeOf<import("../Entity/entityCommands").UpdateEntityCommandSchema<"CompanyNetwork.UpdateCompanyNetwork", {
    uid: z.ZodString;
    subscriptionType: z.ZodNativeEnum<typeof import("@signageos/common-types/dist/Subscription/subscription").SubscriptionType>;
    whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
    deviceFilter: z.ZodOptional<z.ZodObject<Pick<{
        search: z.ZodOptional<z.ZodString>;
        organizationUid: z.ZodOptional<z.ZodString>;
        firmwareVersion: z.ZodOptional<z.ZodString>;
        applicationType: z.ZodOptional<z.ZodString>;
        identityHash: z.ZodOptional<z.ZodString>;
        identityHashes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        identityHashesExclude: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        uids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        uidsExclude: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        accountId: z.ZodOptional<z.ZodNumber>;
        applicationTypes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        applicationTypeNotEqual: z.ZodOptional<z.ZodString>;
        model: z.ZodOptional<z.ZodString>;
        brands: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        firmwareType: z.ZodOptional<z.ZodString>;
        serialNumber: z.ZodOptional<z.ZodString>;
        minStorageStatusPercentage: z.ZodOptional<z.ZodNumber>;
        maxStorageStatusPercentage: z.ZodOptional<z.ZodNumber>;
        bannedSince: z.ZodOptional<z.ZodDate>;
        policyUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        createdSince: z.ZodOptional<z.ZodDate>;
        createdUntil: z.ZodOptional<z.ZodDate>;
        filterModelName: z.ZodOptional<z.ZodString>;
        appletUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        osVersions: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        orFilter: z.ZodOptional<z.ZodObject<{
            tagUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            tagWithChildrenUidGroups: z.ZodOptional<z.ZodArray<z.ZodArray<z.ZodString, "many">, "many">>;
            locationUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strict", z.ZodTypeAny, {
            tagUids?: string[] | undefined;
            tagWithChildrenUidGroups?: string[][] | undefined;
            locationUids?: string[] | undefined;
        }, {
            tagUids?: string[] | undefined;
            tagWithChildrenUidGroups?: string[][] | undefined;
            locationUids?: string[] | undefined;
        }>>;
        hasPolicy: z.ZodOptional<z.ZodBoolean>;
        tagUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        tagWithChildrenUidGroups: z.ZodOptional<z.ZodArray<z.ZodArray<z.ZodString, "many">, "many">>;
        locationUids: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "applicationTypes" | "brands">, "strict", z.ZodTypeAny, {
        applicationTypes?: string[] | undefined;
        brands?: string[] | undefined;
    }, {
        applicationTypes?: string[] | undefined;
        brands?: string[] | undefined;
    }>>;
    name: z.ZodString;
}>>;
export declare const AssignWhiteLabelSettingsToCompanyNetwork = "WhiteLabelSettings.AssignToCompanyNetwork";
export declare const AssignWhiteLabelSettingsToCompanyNetworkSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"WhiteLabelSettings.AssignToCompanyNetwork">;
    companyNetworkUid: z.ZodString;
    whiteLabelSettingsUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "WhiteLabelSettings.AssignToCompanyNetwork";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyNetworkUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "WhiteLabelSettings.AssignToCompanyNetwork";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyNetworkUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type AssignWhiteLabelSettingsToCompanyNetwork = z.infer<typeof AssignWhiteLabelSettingsToCompanyNetworkSchema>;
export declare const AssignWhiteLabelSettingsToCompanyNetworkFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyNetworkUid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "WhiteLabelSettings.AssignToCompanyNetwork";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyNetworkUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"WhiteLabelSettings.AssignToCompanyNetwork">;
    companyNetworkUid: z.ZodString;
    whiteLabelSettingsUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "WhiteLabelSettings.AssignToCompanyNetwork";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyNetworkUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "WhiteLabelSettings.AssignToCompanyNetwork";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyNetworkUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const UnassignWhiteLabelSettingsFromCompanyNetwork = "WhiteLabelSettings.UnassignFromCompanyNetwork";
export declare const UnassignWhiteLabelSettingsFromCompanyNetworkSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"WhiteLabelSettings.UnassignFromCompanyNetwork">;
    companyNetworkUid: z.ZodString;
    whiteLabelSettingsUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "WhiteLabelSettings.UnassignFromCompanyNetwork";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyNetworkUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "WhiteLabelSettings.UnassignFromCompanyNetwork";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyNetworkUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type UnassignWhiteLabelSettingsFromCompanyNetwork = z.infer<typeof UnassignWhiteLabelSettingsFromCompanyNetworkSchema>;
export declare const UnassignWhiteLabelSettingsFromCompanyNetworkFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyNetworkUid: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "WhiteLabelSettings.UnassignFromCompanyNetwork";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyNetworkUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"WhiteLabelSettings.UnassignFromCompanyNetwork">;
    companyNetworkUid: z.ZodString;
    whiteLabelSettingsUid: z.ZodUnion<[z.ZodString, z.ZodString]>;
}, "strict", z.ZodTypeAny, {
    type: "WhiteLabelSettings.UnassignFromCompanyNetwork";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyNetworkUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "WhiteLabelSettings.UnassignFromCompanyNetwork";
    whiteLabelSettingsUid: string;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    companyNetworkUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
