"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckActiveBulkOperations = exports.ArchiveBulkOperation = exports.ResumeBulkOperation = exports.PauseBulkOperation = exports.StopBulkOperation = exports.FinishBulkOperationDraft = exports.UpdateBulkOperationDraft = exports.CreateBulkOperation = void 0;
/**
 * Create a bulk operation or bulk operation draft based on configuration received from box.
 */
exports.CreateBulkOperation = 'BulkOperation.CreateBulkOperation';
/**
 * Update a bulk operation draft.
 */
exports.UpdateBulkOperationDraft = 'BulkOperation.UpdateBulkOperationDraft';
/**
 * Finish a bulk operation draft.
 */
exports.FinishBulkOperationDraft = 'BulkOperation.FinishBulkOperationDraft';
/**
 * Stop given bulk operation based on bulk operation uid.
 */
exports.StopBulkOperation = 'BulkOperation.StopBulkOperation';
/**
 * Pause given bulk operation based on bulk operation uid.
 */
exports.PauseBulkOperation = 'BulkOperation.PauseBulkOperation';
/**
 * Resume execution of given bulk operation based on bulk operation uid and rollingUpdate configuration ( optional ).
 */
exports.ResumeBulkOperation = 'BulkOperation.ResumeBulkOperation';
/**
 * Archive given bulk operation based on bulk operation uid.
 */
exports.ArchiveBulkOperation = 'BulkOperation.ArchiveBulkOperation';
/**
 * Check bulk operations which have to be processed
 */
exports.CheckActiveBulkOperations = 'BulkOperation.CheckActiveBulkOperations';
//# sourceMappingURL=bulkOperationCommands.js.map