import { IOriginatorAwareCommand } from '../ICommand';
/**
 * Create a bulk operation or bulk operation draft based on configuration received from box.
 */
export declare const CreateBulkOperation = "BulkOperation.CreateBulkOperation";
export type CreateBulkOperation<BulkCreatable> = IOriginatorAwareCommand<typeof CreateBulkOperation> & BulkCreatable;
/**
 * Update a bulk operation draft.
 */
export declare const UpdateBulkOperationDraft = "BulkOperation.UpdateBulkOperationDraft";
export type UpdateBulkOperationDraft = IOriginatorAwareCommand<typeof UpdateBulkOperationDraft> & {
    uid: string;
    identityHashes: string[];
};
/**
 * Finish a bulk operation draft.
 */
export declare const FinishBulkOperationDraft = "BulkOperation.FinishBulkOperationDraft";
export type FinishBulkOperationDraft = IOriginatorAwareCommand<typeof FinishBulkOperationDraft> & {
    uid: string;
};
/**
 * Stop given bulk operation based on bulk operation uid.
 */
export declare const StopBulkOperation = "BulkOperation.StopBulkOperation";
export type StopBulkOperation<BulkStoppable> = IOriginatorAwareCommand<typeof StopBulkOperation> & BulkStoppable;
/**
 * Pause given bulk operation based on bulk operation uid.
 */
export declare const PauseBulkOperation = "BulkOperation.PauseBulkOperation";
export type PauseBulkOperation<BulkPausable> = IOriginatorAwareCommand<typeof PauseBulkOperation> & BulkPausable;
/**
 * Resume execution of given bulk operation based on bulk operation uid and rollingUpdate configuration ( optional ).
 */
export declare const ResumeBulkOperation = "BulkOperation.ResumeBulkOperation";
export type ResumeBulkOperation<BulkResumable> = IOriginatorAwareCommand<typeof ResumeBulkOperation> & BulkResumable;
/**
 * Archive given bulk operation based on bulk operation uid.
 */
export declare const ArchiveBulkOperation = "BulkOperation.ArchiveBulkOperation";
export type ArchiveBulkOperation<BulkArchivable> = IOriginatorAwareCommand<typeof ArchiveBulkOperation> & BulkArchivable;
/**
 * Check bulk operations which have to be processed
 */
export declare const CheckActiveBulkOperations = "BulkOperation.CheckActiveBulkOperations";
export type CheckActiveBulkOperations = IOriginatorAwareCommand<typeof CheckActiveBulkOperations>;
