import { z } from 'zod';
import IBaseCommand from '../../ICommand';
import ApplicationType from '@signageos/common-types/dist/Application/ApplicationType';
export declare const CreateApplicationVersion = "Application.Version.CreateApplicationVersion";
export declare const CreateApplicationVersionSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Application.Version.CreateApplicationVersion">;
    applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
    frontDisplayVersion: z.ZodString;
    version: z.ZodString;
    supportedFirmwareTypes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, "strict", z.ZodTypeAny, {
    type: "Application.Version.CreateApplicationVersion";
    version: string;
    applicationType: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos";
    frontDisplayVersion: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    supportedFirmwareTypes?: string[] | undefined;
}, {
    type: "Application.Version.CreateApplicationVersion";
    version: string;
    applicationType: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos";
    frontDisplayVersion: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    supportedFirmwareTypes?: string[] | undefined;
}>;
export type CreateApplicationVersion = z.infer<typeof CreateApplicationVersionSchema>;
export declare const CreateApplicationVersionFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    supportedFirmwareTypes?: string[] | undefined;
} & {
    version: string;
    applicationType: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos";
    frontDisplayVersion: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Application.Version.CreateApplicationVersion";
    version: string;
    applicationType: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos";
    frontDisplayVersion: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    supportedFirmwareTypes?: string[] | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Application.Version.CreateApplicationVersion">;
    applicationType: z.ZodEnum<["sssp", "tizen", "webos", "android", "chrome", "brightsign", "linux", "windows", "default", "chromeos"]>;
    frontDisplayVersion: z.ZodString;
    version: z.ZodString;
    supportedFirmwareTypes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, "strict", z.ZodTypeAny, {
    type: "Application.Version.CreateApplicationVersion";
    version: string;
    applicationType: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos";
    frontDisplayVersion: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    supportedFirmwareTypes?: string[] | undefined;
}, {
    type: "Application.Version.CreateApplicationVersion";
    version: string;
    applicationType: "default" | "sssp" | "tizen" | "webos" | "android" | "chrome" | "brightsign" | "linux" | "windows" | "chromeos";
    frontDisplayVersion: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    supportedFirmwareTypes?: string[] | undefined;
}>>;
export declare const PublishApplicationVersion = "Application.Version.PublishApplicationVersion";
export interface PublishApplicationVersion extends IBaseCommand<typeof PublishApplicationVersion> {
    applicationType: ApplicationType;
    version: string;
}
export declare const UnpublishApplicationVersion = "Application.Version.UnpublishApplicationVersion";
export interface UnpublishApplicationVersion extends IBaseCommand<typeof UnpublishApplicationVersion> {
    applicationType: ApplicationType;
    version: string;
}
export declare const DeprecateApplicationVersion = "Application.Version.DeprecateApplicationVersion";
export interface DeprecateApplicationVersion extends IBaseCommand<typeof DeprecateApplicationVersion> {
    applicationType: ApplicationType;
    version: string;
}
export declare const RenewApplicationVersion = "Application.Version.RenewApplicationVersion";
export interface RenewApplicationVersion extends IBaseCommand<typeof RenewApplicationVersion> {
    applicationType: ApplicationType;
    version: string;
}
export declare const UpdateApplicationVersionDescription = "Application.Version.UpdateApplicationVersionDescription";
export interface UpdateApplicationVersionDescription extends IBaseCommand<typeof UpdateApplicationVersionDescription> {
    applicationType: ApplicationType;
    version: string;
    description: string;
}
