"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotifyApplicationVersionBuildFailedFactory = exports.NotifyApplicationVersionBuildFailedSchema = exports.NotifyApplicationVersionBuildFailed = exports.NotifyApplicationVersionBuildSucceededFactory = exports.NotifyApplicationVersionBuildSucceededSchema = exports.NotifyApplicationVersionBuildSucceeded = exports.BuildApplicationVersionFactory = exports.BuildApplicationVersionSchema = exports.BuildApplicationVersion = exports.AppletConfigSchema = exports.ApplicationVersionBuildRequestUidSchema = void 0;
const zod_1 = require("zod");
const subscription_1 = require("@signageos/common-types/dist/Subscription/subscription");
const ICommand_1 = require("../../ICommand");
const ApplicationType_1 = require("@signageos/common-types/dist/Application/ApplicationType");
const organizationCommands_1 = require("../../Organization/organizationCommands");
const commandFactory_1 = require("../../commandFactory");
const generators_1 = require("../../generators");
// Can't use UIDSchema because of legacy data that didn't use standard UID format
exports.ApplicationVersionBuildRequestUidSchema = zod_1.z.string();
exports.AppletConfigSchema = zod_1.z.record(zod_1.z.union([zod_1.z.string(), zod_1.z.array(zod_1.z.string())]));
exports.BuildApplicationVersion = 'Application.Version.BuildApplicationVersion';
exports.BuildApplicationVersionSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.BuildApplicationVersion),
    requestUid: exports.ApplicationVersionBuildRequestUidSchema.default(() => (0, generators_1.uid)()), // default value for backwards-compatibility
    applicationType: ApplicationType_1.ApplicationTypeSchema,
    applicationVersion: zod_1.z.string(),
    applicationSignature: zod_1.z.string().optional(),
    applicationFlavour: zod_1.z.string().optional(),
    bundledAppletUid: zod_1.z.string(),
    bundledAppletName: zod_1.z.string(),
    bundledAppletVersion: zod_1.z.string(),
    bundledAppletUpdatedAt: zod_1.z.date(),
    bundledAppletPublishedSince: zod_1.z.date().nullable().optional(),
    bundledAppletEntryFile: zod_1.z.string(),
    bundledAppletBaseUrl: zod_1.z.string(),
    bundledAppletFiles: zod_1.z.array(zod_1.z.string()),
    bundledAppletConfig: exports.AppletConfigSchema.nullable(),
    bundledFrontAppletVersion: zod_1.z.string().nullable(),
    bundledFrontAppletBinaryFileUrl: zod_1.z.string().nullable(),
    organizationUid: organizationCommands_1.OrganizationUIDSchema,
    organizationName: zod_1.z.string(),
    /**
     * This type can have only subtype of subscription type enum, because device doesn't understand all subscription types (open/platform).
     * See front-display and display-* repos for more details.
     */
    subscriptionType: zod_1.z.literal(subscription_1.SubscriptionType.Platform).or(zod_1.z.literal(subscription_1.SubscriptionType.Open)).optional(),
});
exports.BuildApplicationVersionFactory = (0, commandFactory_1.createCommandFactory)(exports.BuildApplicationVersionSchema, { requestUid: generators_1.uid });
exports.NotifyApplicationVersionBuildSucceeded = 'Application.Version.NotifyApplicationVersionBuildSucceeded';
exports.NotifyApplicationVersionBuildSucceededSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.NotifyApplicationVersionBuildSucceeded),
    requestUid: exports.ApplicationVersionBuildRequestUidSchema,
    archiveUrl: zod_1.z.string(),
    directUrl: zod_1.z.string(),
});
exports.NotifyApplicationVersionBuildSucceededFactory = (0, commandFactory_1.createCommandFactory)(exports.NotifyApplicationVersionBuildSucceededSchema);
exports.NotifyApplicationVersionBuildFailed = 'Application.Version.NotifyApplicationVersionBuildFailed';
exports.NotifyApplicationVersionBuildFailedSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.NotifyApplicationVersionBuildFailed),
    requestUid: exports.ApplicationVersionBuildRequestUidSchema,
});
exports.NotifyApplicationVersionBuildFailedFactory = (0, commandFactory_1.createCommandFactory)(exports.NotifyApplicationVersionBuildFailedSchema);
//# sourceMappingURL=applicationVersionBuildCommands.js.map