import { z } from 'zod';
import { IOriginatorAwareCommand } from '../ICommand';
export declare const AppletUIDSchema: z.ZodUnion<[z.ZodString, z.ZodString]>;
export declare const AppletVersionSchema: z.ZodString;
export type CreateAppletType = 'Applet.CreateApplet';
export declare const CreateApplet: CreateAppletType;
export interface CreateApplet extends IOriginatorAwareCommand<CreateAppletType> {
    uid: string;
    organizationUid: string;
    name: string;
    iconUrl?: string | null;
}
export type UpdateAppletType = 'Applet.UpdateApplet';
export declare const UpdateApplet: UpdateAppletType;
export interface UpdateApplet extends IOriginatorAwareCommand<UpdateAppletType> {
    uid: string;
    organizationUid?: string;
    name?: string;
    iconUrl?: string | null;
}
export type DeleteAppletType = 'Applet.DeleteApplet';
export declare const DeleteApplet: DeleteAppletType;
export interface DeleteApplet extends IOriginatorAwareCommand<DeleteAppletType> {
    uid: string;
}
