"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteAppletVersionFactory = exports.DeleteAppletVersionSchema = exports.DeleteAppletVersion = exports.RenewAppletVersionFactory = exports.RenewAppletVersionSchema = exports.RenewAppletVersion = exports.DeprecateAppletVersionFactory = exports.DeprecateAppletVersionSchema = exports.DeprecateAppletVersion = exports.PublishAppletVersionFactory = exports.PublishAppletVersionSchema = exports.PublishAppletVersion = exports.NotifyAppletVersionBuildFailedFactory = exports.NotifyAppletVersionBuildFailedSchema = exports.NotifyAppletVersionBuildFailed = exports.NotifyAppletVersionBuiltFactory = exports.NotifyAppletVersionBuiltSchema = exports.NotifyAppletVersionBuilt = exports.UpdateAppletVersionFactory = exports.UpdateAppletVersionSchema = exports.UpdateAppletVersion = exports.CreateAppletVersionFactory = exports.CreateAppletVersionSchema = exports.CreateAppletVersion = void 0;
const zod_1 = require("zod");
const ICommand_1 = require("../../ICommand");
const appletCommands_1 = require("../appletCommands");
const commandFactory_1 = require("../../commandFactory");
exports.CreateAppletVersion = 'Applet.Version.CreateAppletVersion';
exports.CreateAppletVersionSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.CreateAppletVersion),
    appletUid: appletCommands_1.AppletUIDSchema,
    version: appletCommands_1.AppletVersionSchema,
    binary: zod_1.z.string().nullable(), // Deprecation note: binary will be deleted in future, will be replace by entryFile.
    frontAppletVersion: zod_1.z.string().nullable(),
    // TODO remove optional when all commands are updated
    bundledFrontApplet: zod_1.z.boolean().optional(),
    entryFile: zod_1.z.string().optional().nullable(), // If entryFile exist applet is multiFile no matter the binary.
});
exports.CreateAppletVersionFactory = (0, commandFactory_1.createCommandFactory)(exports.CreateAppletVersionSchema);
exports.UpdateAppletVersion = 'Applet.Version.UpdateAppletVersion';
exports.UpdateAppletVersionSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.UpdateAppletVersion),
    appletUid: appletCommands_1.AppletUIDSchema,
    version: appletCommands_1.AppletVersionSchema,
    binary: zod_1.z.string().optional().nullable(), // Deprecation note: binary will be deleted in future, will be replace by entryFile.
    frontAppletVersion: zod_1.z.string().optional().nullable(),
    // TODO remove optional when all commands are updated
    bundledFrontApplet: zod_1.z.boolean().optional(),
    entryFile: zod_1.z.string().optional().nullable(), // If entryFile exist applet is multiFile no matter the binary.
});
exports.UpdateAppletVersionFactory = (0, commandFactory_1.createCommandFactory)(exports.UpdateAppletVersionSchema);
exports.NotifyAppletVersionBuilt = 'Applet.Version.NotifyAppletVersionBuilt';
exports.NotifyAppletVersionBuiltSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.NotifyAppletVersionBuilt),
    requestUid: zod_1.z.string(),
    appletUid: appletCommands_1.AppletUIDSchema,
    version: appletCommands_1.AppletVersionSchema,
    // TODO remove optional (next line) when all commands are updated in applet-builder
    originator: ICommand_1.OriginatorAwareCommandSchema.shape.originator.optional(),
});
exports.NotifyAppletVersionBuiltFactory = (0, commandFactory_1.createCommandFactory)(exports.NotifyAppletVersionBuiltSchema);
exports.NotifyAppletVersionBuildFailed = 'Applet.Version.NotifyAppletVersionBuildFailed';
exports.NotifyAppletVersionBuildFailedSchema = ICommand_1.BaseCommandSchema.extend({
    type: zod_1.z.literal(exports.NotifyAppletVersionBuildFailed),
    requestUid: zod_1.z.string(),
    appletUid: appletCommands_1.AppletUIDSchema,
    version: appletCommands_1.AppletVersionSchema,
    error: zod_1.z
        .object({
        name: zod_1.z.literal('EcmaScriptSyntaxErrorSchema'),
        message: zod_1.z.string(),
        pos: zod_1.z.number(),
        loc: zod_1.z.object({
            line: zod_1.z.number(),
            column: zod_1.z.number(),
        }),
        codeFrame: zod_1.z.string(),
    })
        .or(zod_1.z.record(zod_1.z.unknown())),
}).strict();
exports.NotifyAppletVersionBuildFailedFactory = (0, commandFactory_1.createCommandFactory)(exports.NotifyAppletVersionBuildFailedSchema);
exports.PublishAppletVersion = 'Applet.Version.PublishAppletVersion';
exports.PublishAppletVersionSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.PublishAppletVersion),
    appletUid: appletCommands_1.AppletUIDSchema,
    version: appletCommands_1.AppletVersionSchema,
});
exports.PublishAppletVersionFactory = (0, commandFactory_1.createCommandFactory)(exports.PublishAppletVersionSchema);
exports.DeprecateAppletVersion = 'Applet.Version.DeprecateAppletVersion';
exports.DeprecateAppletVersionSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.DeprecateAppletVersion),
    appletUid: appletCommands_1.AppletUIDSchema,
    version: appletCommands_1.AppletVersionSchema,
});
exports.DeprecateAppletVersionFactory = (0, commandFactory_1.createCommandFactory)(exports.DeprecateAppletVersionSchema);
exports.RenewAppletVersion = 'Applet.Version.RenewAppletVersion';
exports.RenewAppletVersionSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.RenewAppletVersion),
    appletUid: appletCommands_1.AppletUIDSchema,
    version: appletCommands_1.AppletVersionSchema,
});
exports.RenewAppletVersionFactory = (0, commandFactory_1.createCommandFactory)(exports.RenewAppletVersionSchema);
exports.DeleteAppletVersion = 'Applet.Version.DeleteAppletVersion';
exports.DeleteAppletVersionSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.DeleteAppletVersion),
    appletUid: appletCommands_1.AppletUIDSchema,
    version: appletCommands_1.AppletVersionSchema,
});
exports.DeleteAppletVersionFactory = (0, commandFactory_1.createCommandFactory)(exports.DeleteAppletVersionSchema);
//# sourceMappingURL=appletVersionCommands.js.map