"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SaltSchema = exports.PasswordHashSchema = void 0;
const zod_1 = require("zod");
/**
 * Use @signageos/lib/dist/Encryption/passwordEncryption module to hash the password
 *
 * @example
 * ```ts
 * import { preEncryptPassword, encryptPassword } from '@signageos/lib/dist/Encryption/passwordEncryption';
 * import { generateSalt } from '@signageos/lib/dist/Hash/generator';
 *
 * const password = 'password';
 * const salt = generateSalt();
 * const preEncryptedPassword = preEncryptPassword(password);
 * const encryptedPassword = await encryptPassword(preEncryptedPassword, salt);
 * ```
 */
exports.PasswordHashSchema = zod_1.z.string().length(64);
exports.SaltSchema = zod_1.z.string().length(40);
//# sourceMappingURL=schemas.js.map