import { z } from 'zod';
export declare const ChangeEmail = "Account.Settings.ChangeEmail";
export declare const ChangeEmailSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Account.Settings.ChangeEmail">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    email: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.ChangeEmail";
    email: string;
    accountId: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Settings.ChangeEmail";
    email: string;
    accountId: string | number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type ChangeEmail = z.infer<typeof ChangeEmailSchema>;
export declare const ChangeEmailFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    email: string;
    accountId: string | number;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.Settings.ChangeEmail";
    email: string;
    accountId: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Account.Settings.ChangeEmail">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    email: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.ChangeEmail";
    email: string;
    accountId: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Settings.ChangeEmail";
    email: string;
    accountId: string | number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
/** @deprecated Use AddAPISecurityToken instead */
export declare const SetAPISecurityToken = "Account.Settings.SetAPISecurityToken";
/** @deprecated Use AddAPISecurityToken instead */
export declare const SetAPISecurityTokenSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Account.Settings.SetAPISecurityToken">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    token: z.ZodString;
    salt: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.SetAPISecurityToken";
    accountId: number;
    salt: string;
    token: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    name?: string | undefined;
}, {
    type: "Account.Settings.SetAPISecurityToken";
    accountId: string | number;
    salt: string;
    token: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    name?: string | undefined;
}>;
/** @deprecated Use AddAPISecurityToken instead */
export type SetAPISecurityToken = z.infer<typeof SetAPISecurityTokenSchema>;
/** @deprecated Use AddAPISecurityToken instead */
export declare const SetAPISecurityTokenFactory: (data: {
    name?: string | undefined;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    accountId: string | number;
    salt: string;
    token: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.Settings.SetAPISecurityToken";
    accountId: number;
    salt: string;
    token: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    name?: string | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    type: z.ZodLiteral<"Account.Settings.SetAPISecurityToken">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    token: z.ZodString;
    salt: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.SetAPISecurityToken";
    accountId: number;
    salt: string;
    token: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    name?: string | undefined;
}, {
    type: "Account.Settings.SetAPISecurityToken";
    accountId: string | number;
    salt: string;
    token: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    name?: string | undefined;
}>>;
export declare const AddAPISecurityToken = "Account.Settings.AddAPISecurityToken";
export declare const AddAPISecurityTokenSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.AddAPISecurityToken">;
    id: z.ZodString;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    token: z.ZodUnion<[z.ZodString, z.ZodString]>;
    salt: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
    version: z.ZodNumber;
    organizationUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.AddAPISecurityToken";
    id: string;
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    salt: string;
    token: string;
    version: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    name?: string | undefined;
    organizationUid?: string | undefined;
}, {
    type: "Account.Settings.AddAPISecurityToken";
    id: string;
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    salt: string;
    token: string;
    version: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    name?: string | undefined;
    organizationUid?: string | undefined;
}>;
export type AddAPISecurityToken = z.infer<typeof AddAPISecurityTokenSchema>;
export declare const AddAPISecurityTokenFactory: (data: {
    name?: string | undefined;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    organizationUid?: string | undefined;
} & {
    id: string;
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    salt: string;
    token: string;
    version: number;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.Settings.AddAPISecurityToken";
    id: string;
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    salt: string;
    token: string;
    version: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    name?: string | undefined;
    organizationUid?: string | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.AddAPISecurityToken">;
    id: z.ZodString;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    token: z.ZodUnion<[z.ZodString, z.ZodString]>;
    salt: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
    version: z.ZodNumber;
    organizationUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.AddAPISecurityToken";
    id: string;
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    salt: string;
    token: string;
    version: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    name?: string | undefined;
    organizationUid?: string | undefined;
}, {
    type: "Account.Settings.AddAPISecurityToken";
    id: string;
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    salt: string;
    token: string;
    version: number;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
    name?: string | undefined;
    organizationUid?: string | undefined;
}>>;
export declare const RemoveAPISecurityToken = "Account.Settings.RemoveAPISecurityToken";
export declare const RemoveAPISecurityTokenSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.RemoveAPISecurityToken">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    id: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.RemoveAPISecurityToken";
    id: string;
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Settings.RemoveAPISecurityToken";
    id: string;
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type RemoveAPISecurityToken = z.infer<typeof RemoveAPISecurityTokenSchema>;
export declare const RemoveAPISecurityTokenFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    id: string;
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.Settings.RemoveAPISecurityToken";
    id: string;
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.RemoveAPISecurityToken">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    id: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.RemoveAPISecurityToken";
    id: string;
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Settings.RemoveAPISecurityToken";
    id: string;
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const ClearAPISecurityTokens = "Account.Settings.ClearAPISecurityTokens";
export declare const ClearAPISecurityTokensSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.ClearAPISecurityTokens">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.ClearAPISecurityTokens";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Settings.ClearAPISecurityTokens";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type ClearAPISecurityTokens = z.infer<typeof ClearAPISecurityTokensSchema>;
export declare const ClearAPISecurityTokensFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.Settings.ClearAPISecurityTokens";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.ClearAPISecurityTokens">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.ClearAPISecurityTokens";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Settings.ClearAPISecurityTokens";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const SetPassword = "Account.Settings.SetPassword";
export declare const SetPasswordSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.SetPassword">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    password: z.ZodString;
    salt: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.SetPassword";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    password: string;
    salt: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Settings.SetPassword";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    password: string;
    salt: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type SetPassword = z.infer<typeof SetPasswordSchema>;
export declare const SetPasswordFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    password: string;
    salt: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.Settings.SetPassword";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    password: string;
    salt: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.SetPassword">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    password: z.ZodString;
    salt: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.SetPassword";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    password: string;
    salt: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Settings.SetPassword";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    password: string;
    salt: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const ResetPassword = "Account.Settings.ResetPassword";
export declare const ResetPasswordSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.ResetPassword">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.ResetPassword";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Settings.ResetPassword";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type ResetPassword = z.infer<typeof ResetPasswordSchema>;
export declare const ResetPasswordFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.Settings.ResetPassword";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.ResetPassword">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.ResetPassword";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Settings.ResetPassword";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const SetAccountTimezone = "Account.Settings.SetAccountTimezone";
export declare const SetAccountTimezoneSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.SetAccountTimezone">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    timezone: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.SetAccountTimezone";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    timezone: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Settings.SetAccountTimezone";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    timezone: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type SetAccountTimezone = z.infer<typeof SetAccountTimezoneSchema>;
export declare const SetAccountTimezoneFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    timezone: string;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.Settings.SetAccountTimezone";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    timezone: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.SetAccountTimezone">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    timezone: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.SetAccountTimezone";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    timezone: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Settings.SetAccountTimezone";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    timezone: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const SetAccountEmailNotificationsAlertLevel = "Account.Settings.SetAccountEmailNotificationsAlertLevel";
export declare const SetAccountEmailNotificationsAlertLevelSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.SetAccountEmailNotificationsAlertLevel">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    alertLevels: z.ZodArray<z.ZodUnion<[z.ZodLiteral<"info">, z.ZodLiteral<"warning">, z.ZodLiteral<"error">]>, "many">;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.SetAccountEmailNotificationsAlertLevel";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    alertLevels: ("error" | "info" | "warning")[];
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Settings.SetAccountEmailNotificationsAlertLevel";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    alertLevels: ("error" | "info" | "warning")[];
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type SetAccountEmailNotificationsAlertLevel = z.infer<typeof SetAccountEmailNotificationsAlertLevelSchema>;
export declare const SetAccountEmailNotificationsAlertLevelFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    alertLevels: ("error" | "info" | "warning")[];
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.Settings.SetAccountEmailNotificationsAlertLevel";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    alertLevels: ("error" | "info" | "warning")[];
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.SetAccountEmailNotificationsAlertLevel">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    alertLevels: z.ZodArray<z.ZodUnion<[z.ZodLiteral<"info">, z.ZodLiteral<"warning">, z.ZodLiteral<"error">]>, "many">;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.SetAccountEmailNotificationsAlertLevel";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    alertLevels: ("error" | "info" | "warning")[];
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Settings.SetAccountEmailNotificationsAlertLevel";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    alertLevels: ("error" | "info" | "warning")[];
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const SetAccountEmailNotificationsNewsletter = "Account.Settings.SetAccountEmailNotificationsNewsletter";
export declare const SetAccountEmailNotificationsNewsletterSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.SetAccountEmailNotificationsNewsletter">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    isSubscribedToNewsletter: z.ZodBoolean;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.SetAccountEmailNotificationsNewsletter";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    isSubscribedToNewsletter: boolean;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Settings.SetAccountEmailNotificationsNewsletter";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    isSubscribedToNewsletter: boolean;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type SetAccountEmailNotificationsNewsletter = z.infer<typeof SetAccountEmailNotificationsNewsletterSchema>;
export declare const SetAccountEmailNotificationsNewsletterFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    isSubscribedToNewsletter: boolean;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.Settings.SetAccountEmailNotificationsNewsletter";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    isSubscribedToNewsletter: boolean;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.SetAccountEmailNotificationsNewsletter">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    isSubscribedToNewsletter: z.ZodBoolean;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.SetAccountEmailNotificationsNewsletter";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    isSubscribedToNewsletter: boolean;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Settings.SetAccountEmailNotificationsNewsletter";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    isSubscribedToNewsletter: boolean;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const SetWelcomeDashboardSectionsAppearance = "Account.Settings.SetWelcomeDashboardSectionsAppearance";
export declare const SetWelcomeDashboardSectionsAppearanceSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.SetWelcomeDashboardSectionsAppearance">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    sectionsAppearance: z.ZodRecord<z.ZodString, z.ZodString>;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.SetWelcomeDashboardSectionsAppearance";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    sectionsAppearance: Record<string, string>;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Settings.SetWelcomeDashboardSectionsAppearance";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    sectionsAppearance: Record<string, string>;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type SetWelcomeDashboardSectionsAppearance = z.infer<typeof SetWelcomeDashboardSectionsAppearanceSchema>;
export declare const SetWelcomeDashboardSectionsAppearanceFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    sectionsAppearance: Record<string, string>;
} & Partial<import("../types").ObjectRecursiveIntersection<{
    type: "Account.Settings.SetWelcomeDashboardSectionsAppearance";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    sectionsAppearance: Record<string, string>;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Settings.SetWelcomeDashboardSectionsAppearance">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    sectionsAppearance: z.ZodRecord<z.ZodString, z.ZodString>;
}, "strict", z.ZodTypeAny, {
    type: "Account.Settings.SetWelcomeDashboardSectionsAppearance";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    sectionsAppearance: Record<string, string>;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Settings.SetWelcomeDashboardSectionsAppearance";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    sectionsAppearance: Record<string, string>;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
