"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnassignCompanyLicenseFromAccountFactory = exports.UnassignCompanyLicenseFromAccountSchema = exports.UnassignCompanyLicenseFromAccount = exports.AssignCompanyLicenseToAccountFactory = exports.AssignCompanyLicenseToAccountSchema = exports.AssignCompanyLicenseToAccount = exports.ChangeAccountFirstNameAndLastNameFactory = exports.ChangeAccountFirstNameAndLastNameSchema = exports.ChangeAccountFirstNameAndLastName = exports.ActivateAccountFactory = exports.ActivateAccountSchema = exports.ActivateAccount = exports.AddAccountToOrganizationFactory = exports.AddAccountToOrganizationSchema = exports.AddAccountToOrganization = exports.AddAccountToCompanyFactory = exports.AddAccountToCompanySchema = exports.AddAccountToCompany = exports.UpdateAccountAccessLevelFactory = exports.UpdateAccountAccessLevelSchema = exports.UpdateAccountAccessLevel = exports.ResendActivationEmail = exports.ResendAccountActivationEmailFactory = exports.ResendAccountActivationEmailSchema = exports.ResendAccountActivationEmail = exports.CreateSimpleAccountFactory = exports.CreateSimpleAccountSchema = exports.CreateSimpleAccount = exports.CreateAccountFactory = exports.CreateAccountSchema = exports.CreateAccount = exports.AccountIdSchema = void 0;
const zod_1 = require("zod");
const Account_1 = require("@signageos/common-types/dist/Account/Account");
const ICommand_1 = require("../ICommand");
const schemas_1 = require("../schemas");
Object.defineProperty(exports, "AccountIdSchema", { enumerable: true, get: function () { return schemas_1.NumericIdSchema; } });
const commandFactory_1 = require("../commandFactory");
const generators_1 = require("../generators");
const WhiteLabelSettingsUIDSchema_1 = require("../WhiteLabelSettings/WhiteLabelSettingsUIDSchema");
const schemas_2 = require("./schemas");
const companyCommands_1 = require("../Organization/companyCommands");
const License_1 = require("@signageos/common-types/dist/License/License");
exports.CreateAccount = 'Account.CreateAccount';
/**
 * @passwordSecurityToken - token for password setting email
 */
exports.CreateAccountSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.CreateAccount),
    id: schemas_1.NumericIdSchema.default(() => (0, generators_1.numericId)()), // TODO remove optional/default when all services are upgraded
    username: schemas_1.UsernameSchema.optional(),
    email: zod_1.z.string().email(),
    firstname: schemas_1.NameSchema.optional(),
    lastname: schemas_1.NameSchema.optional(),
    accessLevel: Account_1.AccessLevelSchema,
    reason: Account_1.AccountCreationReasonSchema.optional(),
    passwordSecurityToken: zod_1.z.string().default(() => (0, generators_1.uniqueHash)()), // TODO: Remove optional/default when all services are upgraded
    createdAt: zod_1.z.date().default(() => (0, generators_1.now)()), // TODO: Remove optional/default when all services are upgraded
    // TODO remove this once Box stops sending commands with this field and starts sending context instead
    whiteLabelSettingsUid: WhiteLabelSettingsUIDSchema_1.WhiteLabelSettingsUIDSchema.optional(),
    /** Immediately set the account as active */
    activate: zod_1.z.boolean().optional(),
    password: zod_1.z
        .strictObject({
        /** Password hash */
        password: schemas_2.PasswordHashSchema,
        /** Salt used to hash the password */
        salt: schemas_2.SaltSchema,
    })
        .optional(),
});
exports.CreateAccountFactory = (0, commandFactory_1.createCommandFactory)(exports.CreateAccountSchema, {
    id: generators_1.numericId,
    passwordSecurityToken: generators_1.uniqueHash,
    createdAt: generators_1.now,
});
/**
 * Should be used for account creation, which will not be used for authentication trough our system.
 * Auth of this account will be handled via with 3rd party service e.g.: auth0
 *
 * @deprecated Use CreateAccount
 */
exports.CreateSimpleAccount = 'Account.CreateSimpleAccount';
/** @deprecated use CreateAccount */
exports.CreateSimpleAccountSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.CreateSimpleAccount),
    id: zod_1.z.number(),
    email: zod_1.z.string().email(),
    accessLevel: Account_1.AccessLevelSchema,
});
/** @deprecated use CreateAccount */
exports.CreateSimpleAccountFactory = (0, commandFactory_1.createCommandFactory)(exports.CreateSimpleAccountSchema, { id: generators_1.numericId });
exports.ResendAccountActivationEmail = 'Account.ResendActivationEmail';
exports.ResendAccountActivationEmailSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.ResendAccountActivationEmail),
    accountId: schemas_1.NumericIdSchema,
    /**
     * Ideally this field should be required but that would introduce a breaking change to existing producers.
     * To ensure smooth transition, it's first introduced as optional, while all producers change their code to include this field.
     */
    // TODO: Once all producers are updated, it can be safely changed to required.
    companyUid: zod_1.z.string().optional(),
    reason: zod_1.z.union([Account_1.AccountCreationReasonSchema, zod_1.z.undefined()]),
    // TODO remove this once Box stops sending commands with this field and starts sending context instead
    whiteLabelSettingsUid: WhiteLabelSettingsUIDSchema_1.WhiteLabelSettingsUIDSchema.optional(),
});
exports.ResendAccountActivationEmailFactory = (0, commandFactory_1.createCommandFactory)(exports.ResendAccountActivationEmailSchema);
/** @deprecated Use ResendAccountActivationEmail instead */
exports.ResendActivationEmail = exports.ResendAccountActivationEmail;
exports.UpdateAccountAccessLevel = 'Account.UpdateAccountAccessLevel';
exports.UpdateAccountAccessLevelSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.UpdateAccountAccessLevel),
    accountId: schemas_1.NumericIdSchema,
    accessLevel: Account_1.AccessLevelSchema,
});
exports.UpdateAccountAccessLevelFactory = (0, commandFactory_1.createCommandFactory)(exports.UpdateAccountAccessLevelSchema);
exports.AddAccountToCompany = 'Account.AddAccountToCompany';
exports.AddAccountToCompanySchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.AddAccountToCompany),
    email: zod_1.z.string().email(),
    companyUid: schemas_1.LegacyUIDSchema.or(schemas_1.UIDSchema),
    role: zod_1.z.nativeEnum(Account_1.Role),
    accountId: schemas_1.NumericIdSchema,
    // TODO remove this once Box stops sending commands with this field and starts sending context instead
    whiteLabelSettingsUid: WhiteLabelSettingsUIDSchema_1.WhiteLabelSettingsUIDSchema.optional(),
}).strict();
exports.AddAccountToCompanyFactory = (0, commandFactory_1.createCommandFactory)(exports.AddAccountToCompanySchema, { accountId: generators_1.numericId });
exports.AddAccountToOrganization = 'Account.AddAccountToOrganization';
exports.AddAccountToOrganizationSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.AddAccountToOrganization),
    email: zod_1.z.string().email(),
    organizationUid: schemas_1.LegacyUIDSchema.or(schemas_1.UIDSchema),
    role: zod_1.z.nativeEnum(Account_1.Role),
    accountId: schemas_1.NumericIdSchema,
    // TODO remove this once Box stops sending commands with this field and starts sending context instead
    whiteLabelSettingsUid: WhiteLabelSettingsUIDSchema_1.WhiteLabelSettingsUIDSchema.optional(),
}).strict();
exports.AddAccountToOrganizationFactory = (0, commandFactory_1.createCommandFactory)(exports.AddAccountToOrganizationSchema, { accountId: generators_1.numericId });
exports.ActivateAccount = 'Account.ActivateAccount';
exports.ActivateAccountSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.ActivateAccount),
    accountId: schemas_1.NumericIdSchema,
});
exports.ActivateAccountFactory = (0, commandFactory_1.createCommandFactory)(exports.ActivateAccountSchema);
/**
 * *.Settings.* is in the name due the legacy naming. And incorrect placement of this command.
 * So for backwards compatibility we need to keep it like this
 */
exports.ChangeAccountFirstNameAndLastName = 'Account.Settings.ChangeAccountFirstNameAndLastName';
exports.ChangeAccountFirstNameAndLastNameSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.ChangeAccountFirstNameAndLastName),
    accountId: schemas_1.NumericIdSchema,
    firstname: schemas_1.NameSchema.optional(),
    lastname: schemas_1.NameSchema.optional(),
});
exports.ChangeAccountFirstNameAndLastNameFactory = (0, commandFactory_1.createCommandFactory)(exports.ChangeAccountFirstNameAndLastNameSchema);
exports.AssignCompanyLicenseToAccount = 'Account.AssignCompanyLicenseToAccount';
exports.AssignCompanyLicenseToAccountSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.AssignCompanyLicenseToAccount),
    accountId: schemas_1.NumericIdSchema,
    companyUid: companyCommands_1.CompanyUIDSchema,
    license: License_1.LicenseSchema,
});
exports.AssignCompanyLicenseToAccountFactory = (0, commandFactory_1.createCommandFactory)(exports.AssignCompanyLicenseToAccountSchema);
exports.UnassignCompanyLicenseFromAccount = 'Account.UnassignCompanyLicenseFromAccount';
exports.UnassignCompanyLicenseFromAccountSchema = ICommand_1.OriginatorAwareCommandSchema.extend({
    type: zod_1.z.literal(exports.UnassignCompanyLicenseFromAccount),
    accountId: schemas_1.NumericIdSchema,
    companyUid: companyCommands_1.CompanyUIDSchema,
    license: License_1.LicenseSchema,
});
exports.UnassignCompanyLicenseFromAccountFactory = (0, commandFactory_1.createCommandFactory)(exports.UnassignCompanyLicenseFromAccountSchema);
//# sourceMappingURL=accountCommands.js.map