import { z } from 'zod';
export declare const AddAccountSession = "Account.Session.AddAccountSession";
export declare const AddAccountSessionSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Session.AddAccountSession">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    sessionUid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Account.Session.AddAccountSession";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    sessionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Session.AddAccountSession";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    sessionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type AddAccountSession = z.infer<typeof AddAccountSessionSchema>;
export declare const AddAccountSessionFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    sessionUid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Account.Session.AddAccountSession";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    sessionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Session.AddAccountSession">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    sessionUid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Account.Session.AddAccountSession";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    sessionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Session.AddAccountSession";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    sessionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const RemoveAccountSession = "Account.Session.RemoveAccountSession";
export declare const RemoveAccountSessionSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Session.RemoveAccountSession">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    sessionUid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Account.Session.RemoveAccountSession";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    sessionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Session.RemoveAccountSession";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    sessionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type RemoveAccountSession = z.infer<typeof RemoveAccountSessionSchema>;
export declare const RemoveAccountSessionFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    sessionUid: string;
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Account.Session.RemoveAccountSession";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    sessionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Session.RemoveAccountSession">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
    sessionUid: z.ZodString;
}, "strict", z.ZodTypeAny, {
    type: "Account.Session.RemoveAccountSession";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    sessionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Session.RemoveAccountSession";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    sessionUid: string;
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
export declare const RemoveAllAccountSessions = "Account.Session.RemoveAllAccountSessions";
export declare const RemoveAllAccountSessionsSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Session.RemoveAllAccountSessions">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
}, "strict", z.ZodTypeAny, {
    type: "Account.Session.RemoveAllAccountSessions";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Session.RemoveAllAccountSessions";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>;
export type RemoveAllAccountSessions = z.infer<typeof RemoveAllAccountSessionsSchema>;
export declare const RemoveAllAccountSessionsFactory: (data: {
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
} & {
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
} & Partial<import("../../types").ObjectRecursiveIntersection<{
    type: "Account.Session.RemoveAllAccountSessions";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {}, Function>>) => z.TypeOf<z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        whiteLabelSettingsUid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodString]>>;
        auth0Enabled: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }, {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    }>>;
    originator: z.ZodObject<{
        accountId: z.ZodOptional<z.ZodNumber>;
        organizationUid: z.ZodOptional<z.ZodString>;
    }, "strict", z.ZodTypeAny, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }, {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    }>;
    type: z.ZodLiteral<"Account.Session.RemoveAllAccountSessions">;
    accountId: z.ZodEffects<z.ZodUnion<[z.ZodNumber, z.ZodString]>, number, string | number>;
}, "strict", z.ZodTypeAny, {
    type: "Account.Session.RemoveAllAccountSessions";
    accountId: number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}, {
    type: "Account.Session.RemoveAllAccountSessions";
    accountId: string | number;
    originator: {
        accountId?: number | undefined;
        organizationUid?: string | undefined;
    };
    context?: {
        whiteLabelSettingsUid?: string | undefined;
        auth0Enabled?: boolean | undefined;
    } | undefined;
}>>;
