"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UndeliveredEmitError = exports.UnconfirmedMessageError = void 0;
class UnconfirmedMessageError extends Error {
    constructor(responseMessage, requestMessage, failedAt) {
        super(`Response on message cannot be sent because of invalid WS state`);
        this.responseMessage = responseMessage;
        this.requestMessage = requestMessage;
        this.failedAt = failedAt;
        // Set the prototype explicitly because of bug in TypeScript https://github.com/Microsoft/TypeScript/wiki/Breaking-Changes#extending-built-ins-like-error-array-and-map-may-no-longer-work
        Object.setPrototypeOf(this, UnconfirmedMessageError.prototype);
    }
}
exports.UnconfirmedMessageError = UnconfirmedMessageError;
class UndeliveredEmitError extends Error {
    constructor(requestMessage, failedAt) {
        super(`Request message cannot be sent because of invalid WS state`);
        this.requestMessage = requestMessage;
        this.failedAt = failedAt;
        // Set the prototype explicitly because of bug in TypeScript https://github.com/Microsoft/TypeScript/wiki/Breaking-Changes#extending-built-ins-like-error-array-and-map-may-no-longer-work
        Object.setPrototypeOf(this, UndeliveredEmitError.prototype);
    }
}
exports.UndeliveredEmitError = UndeliveredEmitError;
//# sourceMappingURL=ISocket.js.map