import { IncomingHttpHeaders } from 'http';
/**
 * Function for obtaining hostname (domain) from request headers.
 * It uses various HTTP headers because of more contexts of usage (production (CloudFront), pre-production (CloudFront), localhost).
 *
 * Used headers:
 * - x-forwarded-host (i.e. 'box.signageos.io', 'box.signageos.io:8080')
 * - origin (i.e. 'https://box.signageos.io', 'https://box.signageos.io:8080')
 * - referer (i.e. 'https://box.signageos.io', 'https://box.signageos.io:8080')
 * - host (i.e. 'box.signageos.io', 'box.signageos.io:8080')
 *
 * @param headers
 */
export declare const getHostnameFromRequestHeaders: (headers: IncomingHttpHeaders) => string | undefined;
/**
 * Function for obtaining origin (schema + '://' + domain + ':' + port) from request headers.
 * It uses various HTTP headers because of more contexts of usage (production (CloudFront), pre-production (CloudFront), localhost).
 *
 * Used headers:
 * - x-forwarded-host (i.e. 'box.signageos.io', 'box.signageos.io:8080')
 * - origin (i.e. 'https://box.signageos.io', 'https://box.signageos.io:8080')
 * - referer (i.e. 'https://box.signageos.io', 'https://box.signageos.io:8080')
 * - host (i.e. 'box.signageos.io', 'box.signageos.io:8080')
 *
 * @param headers
 */
export declare const getOriginFromRequestHeaders: (headers: IncomingHttpHeaders) => string | undefined;
