"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeoutError = void 0;
exports.rejectAfterTimeout = rejectAfterTimeout;
exports.withTimeout = withTimeout;
class TimeoutError extends Error {
    constructor(message) {
        super(message !== null && message !== void 0 ? message : 'Timeout');
        // Set the prototype explicitly because of bug in TypeScript https://github.com/Microsoft/TypeScript/wiki/Breaking-Changes#extending-built-ins-like-error-array-and-map-may-no-longer-work
        Object.setPrototypeOf(this, TimeoutError.prototype);
    }
}
exports.TimeoutError = TimeoutError;
function rejectAfterTimeout(timeout, errorMessage) {
    return new Promise((_resolve, reject) => {
        setTimeout(() => reject(new TimeoutError(errorMessage)), timeout);
    });
}
/**
 * Wraps promise and returns a new promise that will be rejected
 * after timeoutMs if the original promise is not resolved or rejected.
 */
function withTimeout(promise, timeoutMs, errorMessage) {
    return Promise.race([promise, rejectAfterTimeout(timeoutMs, errorMessage)]);
}
//# sourceMappingURL=timeout.js.map