import TimerType from './PowerTimerType';
import { LongWeekdayEnum, ShortWeekdayEnum } from './PowerTimerWeekdayEnum';
interface CommonTimer {
    type: TimerType;
    timeOn: string | null;
    timeOff: string | null;
}
export interface IShortWeekdayTimer extends CommonTimer {
    weekdays: ShortWeekdayEnum[];
}
/**
 * @deprecated please use IShortWeekdayTimer
 */
export interface ILongWeekdayTimer extends CommonTimer {
    weekdays: LongWeekdayEnum[];
}
/**
 * @deprecated please use IShortWeekdayTimer
 */
export interface ILegacyTimer extends CommonTimer {
    sun: boolean;
    mon: boolean;
    tue: boolean;
    wed: boolean;
    thu: boolean;
    fri: boolean;
    sat: boolean;
}
export default ILegacyTimer;
