"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.redirectConsoleToLogger = redirectConsoleToLogger;
/**
 * This function will redirect all logs that are logged to the console to the logger.
 *
 * The goal is to collect all logs that are not logged through the central logger and make them go through the logger.
 * That way we can control the format and destination of all logs no matter where they are logged.
 */
function redirectConsoleToLogger(logger) {
    console.debug = (message, ...args) => {
        logger.debug(message, { args });
    };
    console.log = (message, ...args) => {
        logger.info(message, { args });
    };
    console.info = (message, ...args) => {
        logger.info(message, { args });
    };
    console.warn = (message, ...args) => {
        logger.warn(message, { args });
    };
    console.error = (message, ...args) => {
        logger.error(message, { args });
    };
}
//# sourceMappingURL=console.js.map