"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateUnionTypeRecursive = generateUnionTypeRecursive;
var checksum_1 = require("../Hash/checksum");
var moduleDiscoverer_1 = require("../FileSystem/moduleDiscoverer");
function generateUnionTypeRecursive(path, typeName) {
    if (typeName === void 0) { typeName = 'IUnionType'; }
    var moduleExports = (0, moduleDiscoverer_1.getModuleExportsRecursive)(path);
    var stringModuleExports = moduleExports.filter(function (moduleExport) { return typeof moduleExport.value === 'string'; });
    var imports = stringModuleExports.reduce(function (reduction, moduleExport) {
        var hash = checksumModuleExport(moduleExport);
        return reduction + "\nimport { ".concat(moduleExport.export, " as ").concat(hash, " } from '").concat(moduleExport.relativePath, "';");
    }, '');
    var unionTypes = stringModuleExports.map(function (moduleExport) { return checksumModuleExport(moduleExport); }).join(' | ');
    return "".concat(imports, "\ntype ").concat(typeName, " = ").concat(unionTypes.length ? unionTypes : 'void', ";\nexport default ").concat(typeName, ";\n");
}
function checksumModuleExport(moduleExport) {
    return moduleExport.export + '_' + (0, checksum_1.checksumString)(moduleExport.relativePath, 5);
}
//# sourceMappingURL=generator.js.map