"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = wait;
function wait(timeout, _a) {
    var _b = _a === void 0 ? {} : _a, signal = _b.signal;
    var timer = undefined;
    var rejectCallback = null;
    var promise = new Promise(function (resolve, reject) {
        rejectCallback = reject;
        timer = setTimeout(function () {
            rejectCallback = null;
            resolve();
        }, timeout);
    });
    promise.cancel = function () {
        if (timer) {
            clearTimeout(timer);
            timer = undefined;
            if (rejectCallback) {
                rejectCallback(new Error('Wait cancelled'));
            }
            rejectCallback = null;
        }
    };
    signal === null || signal === void 0 ? void 0 : signal.addEventListener('abort', function () { return promise.cancel(); });
    return promise;
}
//# sourceMappingURL=wait.js.map