import { Router } from 'express';
export interface IsReadyResultObject {
    ready: boolean;
    response: any;
}
export type IsReadyResult = IsReadyResultObject | boolean;
export type IsReadyCallback = () => Promise<IsReadyResult> | IsReadyResult;
export type ReadinessRouteArgs = {
    router: Router;
    isReady?: IsReadyCallback;
};
/**
 * Runs readiness check and serves the result
 *
 * Responds with 200 if service is ready to serve requests.
 * Typically used by Kubernetes readiness probe.
 */
export declare function routeReadiness({ router, isReady }: ReadinessRouteArgs): void;
