"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.debugClass = debugClass;
var debug_1 = __importDefault(require("debug"));
var debugDecorator_1 = require("./debugDecorator");
/**
 * Add to a class to debug all its method. Based on https://www.typescriptlang.org/docs/handbook/decorators.html#class-decorators
 *
 * For more information see https://www.npmjs.com/package/debug
 *
 * @param namespace Namespace of the debug logs. Run program with env variable DEBUG=<namespace> to enable the logs.
 */
function debugClass(namespace, debugFactory) {
    if (debugFactory === void 0) { debugFactory = debug_1.default; }
    var debugMethod = (0, debugDecorator_1.createDebugMethod)(debugFactory(namespace));
    return function (Target) {
        return /** @class */ (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                var constructorArgs = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    constructorArgs[_i] = arguments[_i];
                }
                var list = Object.getOwnPropertyNames(Target.prototype);
                var _loop_1 = function (methodName) {
                    var originalMethod = Target.prototype[methodName];
                    Target.prototype[methodName] = function () {
                        var args = [];
                        for (var _i = 0; _i < arguments.length; _i++) {
                            args[_i] = arguments[_i];
                        }
                        return debugMethod(originalMethod, this, "".concat(Target.name, ":").concat(methodName), args);
                    };
                };
                for (var _a = 0, list_1 = list; _a < list_1.length; _a++) {
                    var methodName = list_1[_a];
                    _loop_1(methodName);
                }
                return _super.apply(this, constructorArgs) || this;
            }
            return class_1;
        }(Target));
    };
}
//# sourceMappingURL=debugClassDecorator.js.map